/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.Price;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceAmountOnlyExists")
@ImplementedBy(value=Default.class)
public interface PriceAmountOnlyExists
extends Validator<Price> {
    public static final String NAME = "PriceAmountOnlyExists";
    public static final String DEFINITION = "value exists and datedValue is absent";

    public static class NoOp
    implements PriceAmountOnlyExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Price price) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceAmountOnlyExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Price price) {
            ComparisonResult result = this.executeDataRule(price);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceAmountOnlyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Price", (RosettaPath)path, (String)PriceAmountOnlyExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceAmountOnlyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Price", (RosettaPath)path, (String)PriceAmountOnlyExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Price price) {
            try {
                return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)price).map("getValue", _price -> _price.getValue())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)price).mapC("getDatedValue", _price -> _price.getDatedValue())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

