/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.ValuationSource;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ValuationSourceInformationSource")
@ImplementedBy(value=Default.class)
public interface ValuationSourceInformationSource
extends Validator<ValuationSource> {
    public static final String NAME = "ValuationSourceInformationSource";
    public static final String DEFINITION = "required choice informationSource, settlementRateOption, referenceBanks, dealerOrCCP";

    public static class NoOp
    implements ValuationSourceInformationSource {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationSource valuationSource) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ValuationSourceInformationSource {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationSource valuationSource) {
            ComparisonResult result = this.executeDataRule(valuationSource);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ValuationSourceInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationSource", (RosettaPath)path, (String)ValuationSourceInformationSource.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ValuationSourceInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationSource", (RosettaPath)path, (String)ValuationSourceInformationSource.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ValuationSource valuationSource) {
            try {
                return ExpressionOperatorsNullSafe.choice((Mapper)MapperS.of((Object)valuationSource), Arrays.asList("informationSource", "settlementRateOption", "referenceBanks", "dealerOrCCP"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

