/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.Tranche;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TrancheAttachmentPointLessThanExhaustionPoint")
@ImplementedBy(value=Default.class)
public interface TrancheAttachmentPointLessThanExhaustionPoint
extends Validator<Tranche> {
    public static final String NAME = "TrancheAttachmentPointLessThanExhaustionPoint";
    public static final String DEFINITION = "attachmentPoint <= exhaustionPoint";

    public static class NoOp
    implements TrancheAttachmentPointLessThanExhaustionPoint {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Tranche tranche) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TrancheAttachmentPointLessThanExhaustionPoint {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Tranche tranche) {
            ComparisonResult result = this.executeDataRule(tranche);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TrancheAttachmentPointLessThanExhaustionPoint.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Tranche", (RosettaPath)path, (String)TrancheAttachmentPointLessThanExhaustionPoint.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TrancheAttachmentPointLessThanExhaustionPoint.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Tranche", (RosettaPath)path, (String)TrancheAttachmentPointLessThanExhaustionPoint.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Tranche tranche) {
            try {
                return ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)tranche).map("getAttachmentPoint", _tranche -> _tranche.getAttachmentPoint()), (Mapper)MapperS.of((Object)tranche).map("getExhaustionPoint", _tranche -> _tranche.getExhaustionPoint()), (CardinalityOperator)CardinalityOperator.All);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

