/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.validation.datarule;

import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.product.collateral.EligibleCollateralCriteria;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EligibleCollateralCriteriaAverageTradingVolumeEquityOnly")
@ImplementedBy(value=Default.class)
public interface EligibleCollateralCriteriaAverageTradingVolumeEquityOnly
extends Validator<EligibleCollateralCriteria> {
    public static final String NAME = "EligibleCollateralCriteriaAverageTradingVolumeEquityOnly";
    public static final String DEFINITION = "if treatment -> concentrationLimit -> concentrationLimitCriteria -> averageTradingVolume exists then asset -> collateralAssetType -> securityType all = SecurityTypeEnum -> Equity or treatment -> concentrationLimit -> concentrationLimitCriteria -> asset -> collateralAssetType -> securityType all = SecurityTypeEnum -> Equity";

    public static class NoOp
    implements EligibleCollateralCriteriaAverageTradingVolumeEquityOnly {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EligibleCollateralCriteria eligibleCollateralCriteria) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EligibleCollateralCriteriaAverageTradingVolumeEquityOnly {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EligibleCollateralCriteria eligibleCollateralCriteria) {
            ComparisonResult result = this.executeDataRule(eligibleCollateralCriteria);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EligibleCollateralCriteriaAverageTradingVolumeEquityOnly.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EligibleCollateralCriteria", (RosettaPath)path, (String)EligibleCollateralCriteriaAverageTradingVolumeEquityOnly.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EligibleCollateralCriteriaAverageTradingVolumeEquityOnly.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EligibleCollateralCriteria", (RosettaPath)path, (String)EligibleCollateralCriteriaAverageTradingVolumeEquityOnly.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EligibleCollateralCriteria eligibleCollateralCriteria) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)eligibleCollateralCriteria).map("getTreatment", _eligibleCollateralCriteria -> _eligibleCollateralCriteria.getTreatment()).mapC("getConcentrationLimit", collateralTreatment -> collateralTreatment.getConcentrationLimit()).mapC("getConcentrationLimitCriteria", concentrationLimit -> concentrationLimit.getConcentrationLimitCriteria()).map("getAverageTradingVolume", concentrationLimitCriteria -> concentrationLimitCriteria.getAverageTradingVolume())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)eligibleCollateralCriteria).mapC("getAsset", _eligibleCollateralCriteria -> _eligibleCollateralCriteria.getAsset()).mapC("getCollateralAssetType", assetCriteria -> assetCriteria.getCollateralAssetType()).map("getSecurityType", assetType -> assetType.getSecurityType()), (Mapper)MapperS.of((Object)((Object)SecurityTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)eligibleCollateralCriteria).map("getTreatment", _eligibleCollateralCriteria -> _eligibleCollateralCriteria.getTreatment()).mapC("getConcentrationLimit", collateralTreatment -> collateralTreatment.getConcentrationLimit()).mapC("getConcentrationLimitCriteria", concentrationLimit -> concentrationLimit.getConcentrationLimitCriteria()).mapC("getAsset", concentrationLimitCriteria -> concentrationLimitCriteria.getAsset()).mapC("getCollateralAssetType", assetCriteria -> assetCriteria.getCollateralAssetType()).map("getSecurityType", assetType -> assetType.getSecurityType()), (Mapper)MapperS.of((Object)((Object)SecurityTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

