/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.functions;

import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.functions.UpdateAmount;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.functions.PriceUnitEquals;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=UpdatePriceAmountForEachMatchingQuantityDefault.class)
public abstract class UpdatePriceAmountForEachMatchingQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PriceUnitEquals priceUnitEquals;
    @Inject
    protected UpdateAmount updateAmount;

    public FieldWithMetaPriceSchedule evaluate(FieldWithMetaPriceSchedule price, List<? extends PriceSchedule> change, QuantityChangeDirectionEnum direction) {
        FieldWithMetaPriceSchedule updatedPrice;
        FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder updatedPriceBuilder = this.doEvaluate(price, change, direction);
        if (updatedPriceBuilder == null) {
            updatedPrice = null;
        } else {
            updatedPrice = updatedPriceBuilder.build();
            this.objectValidator.validate(FieldWithMetaPriceSchedule.class, (RosettaModelObject)updatedPrice);
        }
        return updatedPrice;
    }

    protected abstract FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder doEvaluate(FieldWithMetaPriceSchedule var1, List<? extends PriceSchedule> var2, QuantityChangeDirectionEnum var3);

    protected abstract MapperS<BigDecimal> changedAmount(FieldWithMetaPriceSchedule var1, List<? extends PriceSchedule> var2, QuantityChangeDirectionEnum var3);

    public static class UpdatePriceAmountForEachMatchingQuantityDefault
    extends UpdatePriceAmountForEachMatchingQuantity {
        @Override
        protected FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder doEvaluate(FieldWithMetaPriceSchedule price, List<? extends PriceSchedule> change, QuantityChangeDirectionEnum direction) {
            if (change == null) {
                change = Collections.emptyList();
            }
            FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder updatedPrice = FieldWithMetaPriceSchedule.builder();
            return this.assignOutput(updatedPrice, price, change, direction);
        }

        protected FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder assignOutput(FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder updatedPrice, FieldWithMetaPriceSchedule price, List<? extends PriceSchedule> change, QuantityChangeDirectionEnum direction) {
            updatedPrice = (FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder)this.toBuilder(price, () -> FieldWithMetaPriceSchedule.builder());
            updatedPrice.getOrCreateValue().setValue((BigDecimal)this.changedAmount(price, change, direction).getOrDefault((Object)((BigDecimal)(price == null ? MapperS.ofNull() : MapperS.of((Object)price.getValue())).map("getValue", priceSchedule -> priceSchedule.getValue()).get())));
            return Optional.ofNullable(updatedPrice).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> changedAmount(FieldWithMetaPriceSchedule price, List<? extends PriceSchedule> change, QuantityChangeDirectionEnum direction) {
            MapperC thenArg0 = MapperC.of(change).filterItemNullSafe(item -> this.priceUnitEquals.evaluate((PriceSchedule)item.get(), price == null ? null : price.getValue()));
            MapperS thenArg1 = thenArg0.first();
            return thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.updateAmount.evaluate((BigDecimal)(price == null ? MapperS.ofNull() : MapperS.of((Object)price.getValue())).map("getValue", priceSchedule -> priceSchedule.getValue()).get(), (BigDecimal)item.map("getValue", priceSchedule -> priceSchedule.getValue()).get(), direction)));
        }
    }
}

