/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceQuantityObservableExists")
@ImplementedBy(value=Default.class)
public interface PriceQuantityObservableExists
extends Validator<PriceQuantity> {
    public static final String NAME = "PriceQuantityObservableExists";
    public static final String DEFINITION = "if price -> arithmeticOperator exists then observable exists";

    public static class NoOp
    implements PriceQuantityObservableExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceQuantityObservableExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
            ComparisonResult result = this.executeDataRule(priceQuantity);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceQuantityObservableExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityObservableExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceQuantityObservableExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityObservableExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PriceQuantity priceQuantity) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)priceQuantity).mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)priceQuantity).map("getObservable", _priceQuantity -> _priceQuantity.getObservable()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

