/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PayoutNotionalResetOnPerformancePayout")
@ImplementedBy(value=Default.class)
public interface PayoutNotionalResetOnPerformancePayout
extends Validator<Payout> {
    public static final String NAME = "PayoutNotionalResetOnPerformancePayout";
    public static final String DEFINITION = "interestRatePayout -> priceQuantity -> reset is absent and creditDefaultPayout -> priceQuantity -> reset is absent and optionPayout -> priceQuantity -> reset is absent and cashflow -> priceQuantity -> reset is absent";

    public static class NoOp
    implements PayoutNotionalResetOnPerformancePayout {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PayoutNotionalResetOnPerformancePayout {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            ComparisonResult result = this.executeDataRule(payout);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PayoutNotionalResetOnPerformancePayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetOnPerformancePayout.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PayoutNotionalResetOnPerformancePayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetOnPerformancePayout.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Payout payout) {
            try {
                return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)payout).map("getCreditDefaultPayout", _payout -> _payout.getCreditDefaultPayout()).map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)payout).mapC("getOptionPayout", _payout -> _payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)payout).mapC("getCashflow", _payout -> _payout.getCashflow()).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

