/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradableProductPredeterminedClearingOrganizationParty")
@ImplementedBy(value=Default.class)
public interface TradableProductPredeterminedClearingOrganizationParty
extends Validator<TradableProduct> {
    public static final String NAME = "TradableProductPredeterminedClearingOrganizationParty";
    public static final String DEFINITION = "if ancillaryParty -> role contains AncillaryRoleEnum -> PredeterminedClearingOrganizationParty then product -> contractualProduct -> economicTerms -> payout -> forwardPayout -> settlementTerms -> physicalSettlementTerms -> predeterminedClearingOrganizationParty exists or product -> contractualProduct -> economicTerms -> payout -> optionPayout -> settlementTerms -> physicalSettlementTerms -> predeterminedClearingOrganizationParty exists";

    public static class NoOp
    implements TradableProductPredeterminedClearingOrganizationParty {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradableProduct tradableProduct) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradableProductPredeterminedClearingOrganizationParty {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradableProduct tradableProduct) {
            ComparisonResult result = this.executeDataRule(tradableProduct);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradableProductPredeterminedClearingOrganizationParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductPredeterminedClearingOrganizationParty.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradableProductPredeterminedClearingOrganizationParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductPredeterminedClearingOrganizationParty.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TradableProduct tradableProduct) {
            try {
                if (ExpressionOperatorsNullSafe.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.PREDETERMINED_CLEARING_ORGANIZATION_PARTY))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getPredeterminedClearingOrganizationParty", physicalSettlementTerms -> physicalSettlementTerms.getPredeterminedClearingOrganizationParty())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getPredeterminedClearingOrganizationParty", physicalSettlementTerms -> physicalSettlementTerms.getPredeterminedClearingOrganizationParty())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

