package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;


@ImplementedBy(AssetClassRule.AssetClassRuleDefault.class)
public abstract class AssetClassRule implements ReportFunction<TransactionReportInstruction, CommonAssetClass> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.trade.contract.reports.AssetClassRule assetClassRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CommonAssetClass evaluate(TransactionReportInstruction input) {
		CommonAssetClass output = doEvaluate(input);
		
		return output;
	}

	protected abstract CommonAssetClass doEvaluate(TransactionReportInstruction input);

	public static class AssetClassRuleDefault extends AssetClassRule {
		@Override
		protected CommonAssetClass doEvaluate(TransactionReportInstruction input) {
			CommonAssetClass output = null;
			return assignOutput(output, input);
		}
		
		protected CommonAssetClass assignOutput(CommonAssetClass output, TransactionReportInstruction input) {
			output = assetClassRule.evaluate(input);
			
			return output;
		}
	}
}
