package drr.regulation.asic.rewrite.valuation.reports;

import cdm.base.datetime.functions.Now;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ValuationReportInstruction;
import java.time.ZonedDateTime;
import javax.inject.Inject;


@ImplementedBy(ReportingTimestampRule.ReportingTimestampRuleDefault.class)
public abstract class ReportingTimestampRule implements ReportFunction<ValuationReportInstruction, ZonedDateTime> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Now now;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ZonedDateTime evaluate(ValuationReportInstruction input) {
		ZonedDateTime output = doEvaluate(input);
		
		return output;
	}

	protected abstract ZonedDateTime doEvaluate(ValuationReportInstruction input);

	public static class ReportingTimestampRuleDefault extends ReportingTimestampRule {
		@Override
		protected ZonedDateTime doEvaluate(ValuationReportInstruction input) {
			ZonedDateTime output = null;
			return assignOutput(output, input);
		}
		
		protected ZonedDateTime assignOutput(ZonedDateTime output, ValuationReportInstruction input) {
			output = now.evaluate();
			
			return output;
		}
	}
}
