package drr.regulation.cftc.rewrite.margin.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.margin.CFTCMarginReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 6.25.3
 */
@RosettaDataRule("CFTCMarginReportCFTC_VR_0120_01")
@ImplementedBy(CFTCMarginReportCFTC_VR_0120_01.Default.class)
public interface CFTCMarginReportCFTC_VR_0120_01 extends Validator<CFTCMarginReport> {
	
	String NAME = "CFTCMarginReportCFTC_VR_0120_01";
	String DEFINITION = "if initialMarginPostedByTheReportingCounterpartyPostHaircut exists or initialMarginPostedByTheReportingCounterpartyPreHaircut exists then currencyOfInitialMarginPosted exists else currencyOfInitialMarginPosted is absent";
	
	class Default implements CFTCMarginReportCFTC_VR_0120_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCMarginReport cFTCMarginReport) {
			ComparisonResult result = executeDataRule(cFTCMarginReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCMarginReport cFTCMarginReport) {
			try {
				if (exists(MapperS.of(cFTCMarginReport).<BigDecimal>map("getInitialMarginPostedByTheReportingCounterpartyPostHaircut", _cFTCMarginReport -> _cFTCMarginReport.getInitialMarginPostedByTheReportingCounterpartyPostHaircut())).orNullSafe(exists(MapperS.of(cFTCMarginReport).<BigDecimal>map("getInitialMarginPostedByTheReportingCounterpartyPreHaircut", _cFTCMarginReport -> _cFTCMarginReport.getInitialMarginPostedByTheReportingCounterpartyPreHaircut()))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCMarginReport).<ISOCurrencyCodeEnum>map("getCurrencyOfInitialMarginPosted", _cFTCMarginReport -> _cFTCMarginReport.getCurrencyOfInitialMarginPosted()));
				}
				return notExists(MapperS.of(cFTCMarginReport).<ISOCurrencyCodeEnum>map("getCurrencyOfInitialMarginPosted", _cFTCMarginReport -> _cFTCMarginReport.getCurrencyOfInitialMarginPosted()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCMarginReportCFTC_VR_0120_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCMarginReport cFTCMarginReport) {
			return Collections.emptyList();
		}
	}
}
