package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(AdjustPeriod.AdjustPeriodDefault.class)
public abstract class AdjustPeriod implements RosettaFunction {

	/**
	* @param period 
	* @param periodMultiplier 
	* @return periodValue 
	*/
	public FrequencyPeriodEnum evaluate(FrequencyPeriodEnum period, BigDecimal periodMultiplier) {
		FrequencyPeriodEnum periodValue = doEvaluate(period, periodMultiplier);
		
		return periodValue;
	}

	protected abstract FrequencyPeriodEnum doEvaluate(FrequencyPeriodEnum period, BigDecimal periodMultiplier);

	public static class AdjustPeriodDefault extends AdjustPeriod {
		@Override
		protected FrequencyPeriodEnum doEvaluate(FrequencyPeriodEnum period, BigDecimal periodMultiplier) {
			FrequencyPeriodEnum periodValue = null;
			return assignOutput(periodValue, period, periodMultiplier);
		}
		
		protected FrequencyPeriodEnum assignOutput(FrequencyPeriodEnum periodValue, FrequencyPeriodEnum period, BigDecimal periodMultiplier) {
			if (areEqual(MapperS.of(period), MapperS.of(FrequencyPeriodEnum.MNTH), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(periodMultiplier), MapperS.of(BigDecimal.valueOf(12)), CardinalityOperator.All)).getOrDefault(false)) {
				periodValue = FrequencyPeriodEnum.YEAR;
			} else {
				periodValue = period;
			}
			
			return periodValue;
		}
	}
}
