package drr.regulation.common.functions;

import cdm.base.staticdata.party.EntityIdentifier;
import cdm.base.staticdata.party.EntityIdentifierTypeEnum;
import cdm.base.staticdata.party.LegalEntity;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.ReferenceInformation;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.util.functions.StringContains;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ExtractReferenceEntity.ExtractReferenceEntityDefault.class)
public abstract class ExtractReferenceEntity implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected StringContains stringContains;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param reportableEvent 
	* @return referenceEntity 
	*/
	public String evaluate(ReportableEvent reportableEvent) {
		String referenceEntity = doEvaluate(reportableEvent);
		
		return referenceEntity;
	}

	protected abstract String doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends FieldWithMetaString> referenceEntityByType(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends FieldWithMetaString> referenceEntityByScheme(ReportableEvent reportableEvent);

	public static class ExtractReferenceEntityDefault extends ExtractReferenceEntity {
		@Override
		protected String doEvaluate(ReportableEvent reportableEvent) {
			String referenceEntity = null;
			return assignOutput(referenceEntity, reportableEvent);
		}
		
		protected String assignOutput(String referenceEntity, ReportableEvent reportableEvent) {
			final MapperC<FieldWithMetaString> thenArg1;
			if (exists(referenceEntityByType(reportableEvent)).getOrDefault(false)) {
				thenArg1 = MapperC.of(referenceEntityByType(reportableEvent));
			} else if (exists(referenceEntityByScheme(reportableEvent)).andNullSafe(notEqual(referenceEntityByScheme(reportableEvent).<String>map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), MapperS.of(""), CardinalityOperator.Any)).getOrDefault(false)) {
				thenArg1 = MapperC.of(referenceEntityByScheme(reportableEvent));
			} else if (exists(referenceEntityProduct(reportableEvent).<EntityIdentifier>mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier()).<FieldWithMetaString>map("getIdentifier", entityIdentifier -> entityIdentifier.getIdentifier())).getOrDefault(false)) {
				final MapperC<FieldWithMetaString> thenArg0 = referenceEntityProduct(reportableEvent).<EntityIdentifier>mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier()).<FieldWithMetaString>map("getIdentifier", entityIdentifier -> entityIdentifier.getIdentifier());
				thenArg1 = MapperC.of(thenArg0
					.last());
			} else {
				thenArg1 = referenceEntityProduct(reportableEvent).<FieldWithMetaString>mapC("getEntityId", legalEntity -> legalEntity.getEntityId());
			}
			final FieldWithMetaString fieldWithMetaString1 = thenArg1
				.last().get();
			if (fieldWithMetaString1 == null) {
				referenceEntity = null;
			} else {
				referenceEntity = fieldWithMetaString1.getValue();
			}
			
			return referenceEntity;
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			return MapperS.of(productForEvent.evaluate(reportableEvent));
		}
		
		@Override
		protected MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEvent reportableEvent) {
			final Boolean boolean0 = isCreditSwaption.evaluate(product(reportableEvent).get());
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<LegalEntity>map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
			}
			final Boolean boolean1 = isCreditDefaultSwap.evaluate(product(reportableEvent).get());
			if ((boolean1 == null ? false : boolean1)) {
				return product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<LegalEntity>map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
			}
			return MapperS.<LegalEntity>ofNull();
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> referenceEntityByType(ReportableEvent reportableEvent) {
			final MapperC<EntityIdentifier> thenArg0 = referenceEntityProduct(reportableEvent).<EntityIdentifier>mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier());
			final MapperC<EntityIdentifier> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(MapperC.<EntityIdentifierTypeEnum>of(MapperS.of(EntityIdentifierTypeEnum.LEI), MapperS.of(EntityIdentifierTypeEnum.COUNTRY_CODE)), item.<EntityIdentifierTypeEnum>map("getIdentifierType", entityIdentifier -> entityIdentifier.getIdentifierType()), CardinalityOperator.Any).get());
			final MapperC<FieldWithMetaString> thenArg2 = thenArg1
				.mapItem(item -> item.<FieldWithMetaString>map("getIdentifier", entityIdentifier -> entityIdentifier.getIdentifier()));
			return thenArg2
				.first();
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> referenceEntityByScheme(ReportableEvent reportableEvent) {
			final MapperC<FieldWithMetaString> thenArg0 = referenceEntityProduct(reportableEvent).<FieldWithMetaString>mapC("getEntityId", legalEntity -> legalEntity.getEntityId());
			final MapperC<FieldWithMetaString> thenArg1 = thenArg0
				.filterItemNullSafe(item -> ComparisonResult.ofNullSafe(MapperS.of(stringContains.evaluate(item.map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()).get(), "http://www.fpml.org/coding-scheme/external/iso17442"))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(stringContains.evaluate(item.map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()).get(), "http://www.fpml.org/coding-scheme/external/iso3166")))).get());
			return thenArg1
				.first();
		}
	}
}
