package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.enrichment.upi.functions.ConvertCurrency;
import drr.standards.iosco.cde.base.quantity.reports.FXNotionalCurrencyRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetOtherUnderlierLeg1.GetOtherUnderlierLeg1Default.class)
public abstract class GetOtherUnderlierLeg1 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected ConvertCurrency convertCurrency;
	@Inject protected FXLeg1 fXLeg1;
	@Inject protected FXNotionalCurrencyRule fXNotionalCurrencyRule;
	@Inject protected FXSwapLeg1 fXSwapLeg1;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsFRA isFRA;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFXSwap isFXSwap;

	/**
	* @param product 
	* @return otherId 
	*/
	public String evaluate(Product product) {
		String otherId = doEvaluate(product);
		
		return otherId;
	}

	protected abstract String doEvaluate(Product product);

	public static class GetOtherUnderlierLeg1Default extends GetOtherUnderlierLeg1 {
		@Override
		protected String doEvaluate(Product product) {
			String otherId = null;
			return assignOutput(otherId, product);
		}
		
		protected String assignOutput(String otherId, Product product) {
			if (ComparisonResult.ofNullSafe(MapperS.of(isFRA.evaluate(product))).andNullSafe(notExists(MapperS.of(interestRateLeg1.evaluate(product)).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption0 -> referenceWithMetaFloatingRateOption0 == null ? null : referenceWithMetaFloatingRateOption0.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>mapC("getIndexId", indexReferenceInformation -> indexReferenceInformation.getIndexId()))).getOrDefault(false)) {
				final FieldWithMetaString fieldWithMetaString = MapperS.of(interestRateLeg1.evaluate(product)).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption1 -> referenceWithMetaFloatingRateOption1 == null ? null : referenceWithMetaFloatingRateOption1.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName()).get();
				if (fieldWithMetaString == null) {
					otherId = null;
				} else {
					otherId = fieldWithMetaString.getValue();
				}
			} else if (ComparisonResult.ofNullSafe(MapperS.of(isFXForward.evaluate(product))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isFXOption.evaluate(product)))).getOrDefault(false)) {
				otherId = convertCurrency.evaluate(fXNotionalCurrencyRule.evaluate(fXLeg1.evaluate(product)));
			} else {
				final Boolean _boolean = isFXSwap.evaluate(product);
				if ((_boolean == null ? false : _boolean)) {
					otherId = convertCurrency.evaluate(fXNotionalCurrencyRule.evaluate(fXSwapLeg1.evaluate(product)));
				} else {
					otherId = null;
				}
			}
			
			return otherId;
		}
	}
}
