package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(SettlementTermsLeg1.SettlementTermsLeg1Default.class)
public abstract class SettlementTermsLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXFarLeg fXFarLeg;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
	@Inject protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;

	/**
	* @param product 
	* @return settlementTerms 
	*/
	public SettlementTerms evaluate(Product product) {
		SettlementTerms.SettlementTermsBuilder settlementTermsBuilder = doEvaluate(product);
		
		final SettlementTerms settlementTerms;
		if (settlementTermsBuilder == null) {
			settlementTerms = null;
		} else {
			settlementTerms = settlementTermsBuilder.build();
			objectValidator.validate(SettlementTerms.class, settlementTerms);
		}
		
		return settlementTerms;
	}

	protected abstract SettlementTerms.SettlementTermsBuilder doEvaluate(Product product);

	protected abstract MapperS<? extends EconomicTerms> economicTerms(Product product);

	public static class SettlementTermsLeg1Default extends SettlementTermsLeg1 {
		@Override
		protected SettlementTerms.SettlementTermsBuilder doEvaluate(Product product) {
			SettlementTerms.SettlementTermsBuilder settlementTerms = SettlementTerms.builder();
			return assignOutput(settlementTerms, product);
		}
		
		protected SettlementTerms.SettlementTermsBuilder assignOutput(SettlementTerms.SettlementTermsBuilder settlementTerms, Product product) {
			if (exists(MapperS.of(interestRateLeg1.evaluate(product)).<SettlementTerms>map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms())).getOrDefault(false)) {
				settlementTerms = toBuilder(MapperS.of(interestRateLeg1.evaluate(product)).<SettlementTerms>map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()).get());
			} else if (exists(economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<SettlementTerms>map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms())).getOrDefault(false)) {
				settlementTerms = toBuilder(economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<SettlementTerms>map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).get());
			} else if (exists(economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<SettlementTerms>map("getSettlementTerms", performancePayout -> performancePayout.getSettlementTerms())).getOrDefault(false)) {
				settlementTerms = toBuilder(MapperS.of(economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<SettlementTerms>map("getSettlementTerms", performancePayout -> performancePayout.getSettlementTerms()).get());
			} else {
				final Boolean boolean0 = isFXSwap.evaluate(product);
				if ((boolean0 == null ? false : boolean0)) {
					settlementTerms = toBuilder(MapperS.of(fXFarLeg.evaluate(product)).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).get());
				} else {
					final Boolean boolean1 = isCommoditySwapFloatFloat.evaluate(product);
					if ((boolean1 == null ? false : boolean1)) {
						settlementTerms = toBuilder(MapperS.of(commodityLeg1.evaluate(product)).<SettlementTerms>map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).get());
					} else {
						final Boolean boolean2 = isSingleCommodityPayoutProduct.evaluate(product);
						if ((boolean2 == null ? false : boolean2)) {
							settlementTerms = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<SettlementTerms>map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).get());
						} else {
							final Boolean boolean3 = isCommoditySwapFixedFloat.evaluate(product);
							if ((boolean3 == null ? false : boolean3)) {
								settlementTerms = toBuilder(MapperS.of(fixedPriceLeg1.evaluate(product)).<SettlementTerms>map("getSettlementTerms", fixedPricePayout -> fixedPricePayout.getSettlementTerms()).get());
							} else if (areEqual(MapperS.of(isCommodityFixedPriceForward.evaluate(product)), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
								settlementTerms = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()).<SettlementTerms>map("getSettlementTerms", fixedPricePayout -> fixedPricePayout.getSettlementTerms()).get());
							} else if (areEqual(MapperS.of(isCommodityFloatingPriceForward.evaluate(product)), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
								settlementTerms = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<SettlementTerms>map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).get());
							} else if (exists(economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<SettlementTerms>map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms())).getOrDefault(false)) {
								settlementTerms = toBuilder(MapperS.of(economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<SettlementTerms>map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).get());
							} else if (exists(MapperS.of(economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms())).getOrDefault(false)) {
								settlementTerms = toBuilder(MapperS.of(economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).get());
							} else {
								settlementTerms = null;
							}
						}
					}
				}
			}
			
			return Optional.ofNullable(settlementTerms)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends EconomicTerms> economicTerms(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product));
		}
	}
}
