package drr.regulation.common.trade.party.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.TransactionReportInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ExtractRegimeInformation.ExtractRegimeInformationDefault.class)
public abstract class ExtractRegimeInformation implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param transactionReportInstruction 
	* @param party 
	* @return result 
	*/
	public List<? extends ReportingRegime> evaluate(TransactionReportInstruction transactionReportInstruction, Party party) {
		List<ReportingRegime.ReportingRegimeBuilder> resultBuilder = doEvaluate(transactionReportInstruction, party);
		
		final List<? extends ReportingRegime> result;
		if (resultBuilder == null) {
			result = null;
		} else {
			result = resultBuilder.stream().map(ReportingRegime::build).collect(Collectors.toList());
			objectValidator.validate(ReportingRegime.class, result);
		}
		
		return result;
	}

	protected abstract List<ReportingRegime.ReportingRegimeBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction, Party party);

	public static class ExtractRegimeInformationDefault extends ExtractRegimeInformation {
		@Override
		protected List<ReportingRegime.ReportingRegimeBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction, Party party) {
			List<ReportingRegime.ReportingRegimeBuilder> result = new ArrayList<>();
			return assignOutput(result, transactionReportInstruction, party);
		}
		
		protected List<ReportingRegime.ReportingRegimeBuilder> assignOutput(List<ReportingRegime.ReportingRegimeBuilder> result, TransactionReportInstruction transactionReportInstruction, Party party) {
			final MapperC<PartyInformation> thenArg0 = MapperS.of(transactionReportInstruction).<ReportableInformation>map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation())
				.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), MapperS.of(party), CardinalityOperator.All).get());
			final MapperListOfLists<ReportingRegime> thenArg1 = thenArg0
				.mapItemToList(item -> item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()));
			result = toBuilder(distinct(thenArg1
				.flattenList()).getMulti());
			
			return Optional.ofNullable(result)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
