package drr.regulation.csa.rewrite.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetNameReport;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class UnderlyingAssetNameReportValidator implements Validator<UnderlyingAssetNameReport> {

	private List<ComparisonResult> getComparisonResults(UnderlyingAssetNameReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("underlyingAssetName", (List<String>) o.getUnderlyingAssetName() == null ? 0 : o.getUnderlyingAssetName().size(), 0, 20)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, UnderlyingAssetNameReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("UnderlyingAssetNameReport", ValidationResult.ValidationType.CARDINALITY, "UnderlyingAssetNameReport", path, "", res.getError());
				}
				return success("UnderlyingAssetNameReport", ValidationResult.ValidationType.CARDINALITY, "UnderlyingAssetNameReport", path, "");
			})
			.collect(toList());
	}

}
