package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg1Aligned;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg2Aligned;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(IsCSAAlignedRule.IsCSAAlignedRuleDefault.class)
public abstract class IsCSAAlignedRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCSALeg1Aligned isCSALeg1Aligned;
	@Inject protected IsCSALeg2Aligned isCSALeg2Aligned;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class IsCSAAlignedRuleDefault extends IsCSAAlignedRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			if (areEqual(MapperS.of(isCSALeg1Aligned.evaluate(input)), MapperS.of(true), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(isCSALeg2Aligned.evaluate(input)), MapperS.of(true), CardinalityOperator.All)).getOrDefault(false)) {
				output = true;
			} else if (areEqual(MapperS.of(isCSALeg1Aligned.evaluate(input)), MapperS.of(false), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(isCSALeg2Aligned.evaluate(input)), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
				output = false;
			} else {
				output = null;
			}
			
			return output;
		}
	}
}
