package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg2Rule;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(SpreadLeg1Rule.SpreadLeg1RuleDefault.class)
public abstract class SpreadLeg1Rule implements ReportFunction<TransactionReportInstruction, PriceFormat> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSAAlignedRule isCSAAlignedRule;
	@Inject protected PriceFormatFromNotation priceFormatFromNotation;
	@Inject protected drr.standards.iosco.cde.version3.price.reports.SpreadLeg1Rule spreadLeg1Rule;
	@Inject protected SpreadLeg2Rule spreadLeg2Rule;
	@Inject protected SpreadNotationLeg1Rule spreadNotationLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceFormat evaluate(TransactionReportInstruction input) {
		PriceFormat.PriceFormatBuilder outputBuilder = doEvaluate(input);
		
		final PriceFormat output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(PriceFormat.class, output);
		}
		
		return output;
	}

	protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input);

	public static class SpreadLeg1RuleDefault extends SpreadLeg1Rule {
		@Override
		protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
			PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
			return assignOutput(output, input);
		}
		
		protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<PriceFormat> ifThenElseResult;
			if (areEqual(MapperS.of(isCSAAlignedRule.evaluate(thenArg.get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(priceFormatFromNotation.evaluate(MapperS.of(spreadLeg1Rule.evaluate(thenArg.get())).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get(), spreadNotationLeg1Rule.evaluate(thenArg.get())));
			} else {
				ifThenElseResult = MapperS.of(priceFormatFromNotation.evaluate(MapperS.of(spreadLeg2Rule.evaluate(thenArg.get())).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get(), spreadNotationLeg1Rule.evaluate(thenArg.get())));
			}
			output = toBuilder(ifThenElseResult.get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
