package drr.regulation.fca.ukemir.refit.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.lei.LeiGeneralCategoryEnum;
import drr.enrichment.lei.functions.API_GetLeiData;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRMarginReport;
import drr.regulation.fca.ukemir.refit.margin.PartiesToTheDerivative;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 6.25.3
 */
@RosettaDataRule("FCAUKEMIRMarginReportUKEMIR_VR_3002_03")
@ImplementedBy(FCAUKEMIRMarginReportUKEMIR_VR_3002_03.Default.class)
public interface FCAUKEMIRMarginReportUKEMIR_VR_3002_03 extends Validator<FCAUKEMIRMarginReport> {
	
	String NAME = "FCAUKEMIRMarginReportUKEMIR_VR_3002_03";
	String DEFINITION = "API_GetLeiData(partiesToTheDerivative -> reportSubmittingEntityID) -> generalCategory <> LeiGeneralCategoryEnum -> BRANCH";
	
	class Default implements FCAUKEMIRMarginReportUKEMIR_VR_3002_03 {
	
		@Inject protected API_GetLeiData aPI_GetLeiData;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRMarginReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			try {
				return notEqual(MapperS.of(aPI_GetLeiData.evaluate(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getReportSubmittingEntityID", partiesToTheDerivative -> partiesToTheDerivative.getReportSubmittingEntityID()).get())).<LeiGeneralCategoryEnum>map("getGeneralCategory", leiData -> leiData.getGeneralCategory()), MapperS.of(LeiGeneralCategoryEnum.BRANCH), CardinalityOperator.Any);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRMarginReportUKEMIR_VR_3002_03 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			return Collections.emptyList();
		}
	}
}
