package drr.regulation.fca.ukemir.refit.margin.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.margin.CollateralReport;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRMarginReport;
import drr.regulation.fca.ukemir.refit.margin.PartiesToTheDerivative;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class FCAUKEMIRMarginReportOnlyExistsValidator implements ValidatorWithArg<FCAUKEMIRMarginReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends FCAUKEMIRMarginReport> ValidationResult<FCAUKEMIRMarginReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("partiesToTheDerivative", ExistenceChecker.isSet((PartiesToTheDerivative) o.getPartiesToTheDerivative()))
				.put("collateral", ExistenceChecker.isSet((CollateralReport) o.getCollateral()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("FCAUKEMIRMarginReport", ValidationResult.ValidationType.ONLY_EXISTS, "FCAUKEMIRMarginReport", path, "");
		}
		return failure("FCAUKEMIRMarginReport", ValidationResult.ValidationType.ONLY_EXISTS, "FCAUKEMIRMarginReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
