package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetUnderlierProductIdentifier;
import drr.regulation.common.functions.GetUnderlyingIdentificationType;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(UnderlyingIdentificationRule.UnderlyingIdentificationRuleDefault.class)
public abstract class UnderlyingIdentificationRule implements ReportFunction<TransactionReportInstruction, List<String>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetUnderlierProductIdentifier getUnderlierProductIdentifier;
	@Inject protected GetUnderlyingIdentificationType getUnderlyingIdentificationType;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(TransactionReportInstruction input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(TransactionReportInstruction input);

	public static class UnderlyingIdentificationRuleDefault extends UnderlyingIdentificationRule {
		@Override
		protected List<String> doEvaluate(TransactionReportInstruction input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = thenArg
				.mapSingleToList(item -> {
					if (exists(MapperS.of(getUnderlyingIdentificationType.evaluate(item.get()))).getOrDefault(false)) {
						final MapperS<Product> _thenArg;
						if (ComparisonResult.ofNullSafe(MapperS.of(isCreditSwaption.evaluate(productForEvent.evaluate(item.get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isIRSwaption.evaluate(productForEvent.evaluate(item.get()))))).getOrDefault(false)) {
							_thenArg = MapperS.of(underlierForProduct.evaluate(productForEvent.evaluate(item.get())));
						} else {
							_thenArg = MapperS.of(productForEvent.evaluate(item.get()));
						}
						return _thenArg
							.mapSingleToList(_item -> MapperC.<ProductIdentifier>of(getUnderlierProductIdentifier.evaluate(_item.get())).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()));
					}
					return MapperC.<FieldWithMetaString>ofNull();
				}).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti();
			
			return output;
		}
	}
}
