package drr.regulation.hkma.rewrite.trade.reports;

import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.UTIProprietarySchemeNameEnum;
import drr.regulation.hkma.rewrite.trade.functions.Extract_HKMATransactionSchemeName;
import drr.regulation.hkma.rewrite.trade.functions.Extract_PriorUTIPropietary;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PriorUTIProprietarySchemeNameRule.PriorUTIProprietarySchemeNameRuleDefault.class)
public abstract class PriorUTIProprietarySchemeNameRule implements ReportFunction<TransactionReportInstruction, UTIProprietarySchemeNameEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Extract_HKMATransactionSchemeName extract_HKMATransactionSchemeName;
	@Inject protected Extract_PriorUTIPropietary extract_PriorUTIPropietary;
	@Inject protected PriorUTIProprietaryRule priorUTIProprietaryRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public UTIProprietarySchemeNameEnum evaluate(TransactionReportInstruction input) {
		UTIProprietarySchemeNameEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract UTIProprietarySchemeNameEnum doEvaluate(TransactionReportInstruction input);

	public static class PriorUTIProprietarySchemeNameRuleDefault extends PriorUTIProprietarySchemeNameRule {
		@Override
		protected UTIProprietarySchemeNameEnum doEvaluate(TransactionReportInstruction input) {
			UTIProprietarySchemeNameEnum output = null;
			return assignOutput(output, input);
		}
		
		protected UTIProprietarySchemeNameEnum assignOutput(UTIProprietarySchemeNameEnum output, TransactionReportInstruction input) {
			final MapperS<TradeIdentifier> thenArg;
			if (exists(MapperS.of(priorUTIProprietaryRule.evaluate(input))).getOrDefault(false)) {
				thenArg = MapperS.of(extract_PriorUTIPropietary.evaluate(input));
			} else {
				thenArg = MapperS.<TradeIdentifier>ofNull();
			}
			output = MapperS.of(extract_HKMATransactionSchemeName.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
