package drr.regulation.mas.rewrite.trade.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class MASTradeLabelProvider extends GraphBasedLabelProvider {
	public MASTradeLabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("effectiveDate"), "31 Effective Date");
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "50 Reporting Timestamp");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "49 Execution Timestamp");
		startNode.addLabel(Arrays.asList("expirationDate"), "32 Expiration Date");
		startNode.addLabel(Arrays.asList("counterparty1"), "1 Counterparty 1");
		startNode.addLabel(Arrays.asList("counterparty2"), "2 Counterparty 2");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierType"), "3 Counterparty 2 Identifier Type");
		startNode.addLabel(Arrays.asList("cleared"), "39 Cleared");
		startNode.addLabel(Arrays.asList("centralCounterparty"), "40 Central Counterparty");
		startNode.addLabel(Arrays.asList("clearingMember"), "41 Clearing member");
		startNode.addLabel(Arrays.asList("confirmed"), "47 Confirmed");
		startNode.addLabel(Arrays.asList("callAmount"), "90 Call amount");
		startNode.addLabel(Arrays.asList("putAmount"), "92 Put Amount");
		startNode.addLabel(Arrays.asList("callCurrency"), "91 Call currency");
		startNode.addLabel(Arrays.asList("putCurrency"), "93 Put currency");
		startNode.addLabel(Arrays.asList("priceSchedule", "price", "monetary"), "98/100-$ 100 Price in effect between the unadjusted effective and end date");
		startNode.addLabel(Arrays.asList("priceSchedule", "price", "decimal"), "98/100-$ 100 Price in effect between the unadjusted effective and end date");
		startNode.addLabel(Arrays.asList("priceSchedule", "effectiveDate"), "98/100-$ 98 Unadjusted effective date of the price");
		startNode.addLabel(Arrays.asList("priceSchedule", "endDate"), "98/100-$ 99 Unadjusted end date of the price");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "price", "monetary"), "104/106-$ 106 Strike price in effect on associated effective date");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "price", "decimal"), "104/106-$ 106 Strike price in effect on associated effective date");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "effectiveDate"), "104/106-$ 104 Effective date of strike price");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "endDate"), "104/106-$ 105 End date of strike price");
		startNode.addLabel(Arrays.asList("price", "decimal"), "94 Price");
		startNode.addLabel(Arrays.asList("price", "monetary"), "94 Price");
		startNode.addLabel(Arrays.asList("priceNotation"), "96 Price notation");
		startNode.addLabel(Arrays.asList("priceCurrency"), "95 Price currency");
		startNode.addLabel(Arrays.asList("packageIdentifier"), "34 Package identifier");
		startNode.addLabel(Arrays.asList("strikePrice", "decimal"), "101 Strike Price");
		startNode.addLabel(Arrays.asList("strikePrice", "monetary"), "101 Strike Price");
		startNode.addLabel(Arrays.asList("strikePriceNotation"), "103 Strike Price Notation");
		startNode.addLabel(Arrays.asList("strikePriceCurrency"), "102 Strike price currency/currency pair");
		startNode.addLabel(Arrays.asList("priceUnitOfMeasure"), "97 Price unit of measure");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "107 Option Premium Amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "108 Option Premium Currency");
		startNode.addLabel(Arrays.asList("exchangeRate"), "109 Exchange rate");
		startNode.addLabel(Arrays.asList("exchangeRateBasis"), "110 Exchange Rate Basis");
		startNode.addLabel(Arrays.asList("collateralPortfolioIndicator"), "57 Collateral Portfolio Indicator");
		startNode.addLabel(Arrays.asList("firstExerciseDate"), "30 First exercise date");
		startNode.addLabel(Arrays.asList("finalContractualSettlementDate"), "38 Final Contractual Settlement Date");
		startNode.addLabel(Arrays.asList("priorUTI"), "12 Prior UTI");
		startNode.addLabel(Arrays.asList("valuationAmount"), "53 Valuation amount");
		startNode.addLabel(Arrays.asList("valuationCurrency"), "54 Valuation currency");
		startNode.addLabel(Arrays.asList("valuationMethod"), "55 Valuation method");
		startNode.addLabel(Arrays.asList("valuationTimestamp"), "56 Valuation Timestamp");
		startNode.addLabel(Arrays.asList("basketConstituents", "identifier"), "51/52-$ 51 Basket constituent identifiers");
		startNode.addLabel(Arrays.asList("basketConstituents", "source"), "51/52-$ 52 Source of the identifier of the basket constituents");
		startNode.addLabel(Arrays.asList("otherPayment", "paymentType"), "127/132-$ 127 Other Payment Type");
		startNode.addLabel(Arrays.asList("otherPayment", "amount"), "128/132-$ 128 Other Payment Amount");
		startNode.addLabel(Arrays.asList("otherPayment", "currency"), "129/132-$ 129 Other Payment Currency");
		startNode.addLabel(Arrays.asList("otherPayment", "date"), "130/132-$ 130 Other Payment Date");
		startNode.addLabel(Arrays.asList("otherPayment", "payer"), "130/132-$ 131 Other Payment Payer");
		startNode.addLabel(Arrays.asList("otherPayment", "payerFormat"), "130/132-$ 131 Other Payment Payer Format (non-reportable)");
		startNode.addLabel(Arrays.asList("otherPayment", "receiver"), "131/132-$ 132 Other Payment Receiver");
		startNode.addLabel(Arrays.asList("otherPayment", "receiverFormat"), "131/132-$ 132 Other Payment Receiver Format (non-reportable)");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateIdentifier"), "17 Identifier of the floating rate of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "nameOfTheFloatingRate"), "18 Name of the Floating Rate of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRateDayCountConvention"), "111 Fixed rate day count convention of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateDayCountConvention"), "113 Floating rate day count convention of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyPeriod"), "115 Floating rate reset frequency period of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "116 Floating rate reset frequency period multiplier of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "119 Fixed rate payment frequency period of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "120 Fixed rate payment frequency period multiplier of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "123 Floating rate payment frequency period of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "124 Floating rate payment frequency period multiplier of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "direction2"), "6 Direction of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "fixedRate"), "16 Fixed Rate of leg 1 or coupon");
		startNode.addLabel(Arrays.asList("leg1", "spread", "monetary"), "19 Spread of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spread", "decimal"), "19 Spread of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spread", "basis"), "19 Spread of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spreadNotation"), "20 Spread notation of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spreadCurrency"), "21 Spread currency of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "settlementCurrency"), "36 Settlement Currency 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmount"), "76 Notional amount of the contract or leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalCurrency"), "77 Notional currency of the contract or leg 1");
		startNode.addLabel(Arrays.asList("leg1", "totalNotionalQuantity"), "80 Total notional quantity of the contract or leg 1");
		startNode.addLabel(Arrays.asList("leg1", "quantityUnitOfMeasure"), "81 Quantity unit of measure for the contract or leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantity"), "82 Notional quantity of the contract or leg 1 (where applicable)");
		startNode.addLabel(Arrays.asList("leg1", "quantityFrequency"), "83 Quantity frequency of the contract or leg 1");
		startNode.addLabel(Arrays.asList("leg1", "quantityFrequencyMultiplier"), "84 Quantity frequency multiplier of the contract or leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "value"), "[Not in regulation]-$ Notional amount schedule amount - Leg 1 (DTCC)");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "effectiveDate"), "[Not in regulation]-$ Notional amount schedule effective date - Leg 1 (DTCC)");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "endDate"), "[Not in regulation]-$ Notional amount schedule end date - Leg 1 (DTCC)");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "value"), "[Not in regulation]-$ Notional quantity which becomes effective on thesociated unadjusted effective date-Leg 1 (DTCC)");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "effectiveDate"), "[Not in regulation]-$ Notional quantity schedules - Unadjusted date on which thesociated notional quantity becomes effective of leg 1 (DTCC)");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "endDate"), "[Not in regulation]-$ Notional quantity schedules - Unadjusted end date of the notional quantity of leg 1 (DTCC)");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateIdentifier"), "23 Identifier of the floating rate of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "nameOfTheFloatingRate"), "24 Name of the Floating Rate of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRateDayCountConvention"), "112 Fixed rate day count convention of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateDayCountConvention"), "114 Floating rate day count convention of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyPeriod"), "117 Floating rate reset frequency period of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "118 Floating rate reset frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "121 Fixed rate payment frequency period of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "122 Fixed rate payment frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "125 Floating rate payment frequency period of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "126 Floating rate payment frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "direction2"), "7 Direction of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "fixedRate"), "22 Fixed Rate of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "monetary"), "25 Spread of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "decimal"), "25 Spread of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "basis"), "25 Spread of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spreadNotation"), "26 Spread notation of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spreadCurrency"), "27 Spread Currency of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "settlementCurrency"), "37 Settlement Currency 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalCurrency"), "77 Notional currency of the contract or leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmount"), "78 Notional amount of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "totalNotionalQuantity"), "85 Total notional quantity of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "quantityFrequency"), "85 Quantity frequency multiplier of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "quantityFrequencyMultiplier"), "86 Quantity frequency multiplier of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "quantityUnitOfMeasure"), "86 Quantity Unit Of Measure Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantity"), "87 Notional quantity of leg 2 (where applicable)");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "value"), "[Not in regulation]-$ Notional amount schedule amount - Leg 2 (DTCC)");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "effectiveDate"), "[Not in regulation]-$ Notional amount schedule effective date - Leg 2 (DTCC)");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "endDate"), "[Not in regulation]-$ Notional amount schedule end date - Leg 2 (DTCC)");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "value"), "[Not in regulation]-$ Notional quantity which becomes effective on thesociated unadjusted effective date-Leg 2 (DTCC)");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "effectiveDate"), "[Not in regulation]-$ Notional quantity schedules - Unadjusted date on which thesociated notional quantity becomes effective of leg 2 (DTCC)");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "endDate"), "[Not in regulation]-$ Notional quantity schedules - Unadjusted end date of the notional quantity of leg 2 (DTCC)");
		startNode.addLabel(Arrays.asList("underlyingIdOther"), "15 Underlying ID (Other) (DTCC)");
		startNode.addLabel(Arrays.asList("underlyingIdOtherSource"), "15 Underlying ID (Other) Source (DTCC)");
		startNode.addLabel(Arrays.asList("actionType"), "133 Action type");
		startNode.addLabel(Arrays.asList("eventType"), "134 Event Type");
		startNode.addLabel(Arrays.asList("eventTimestamp"), "135 Event Date");
		startNode.addLabel(Arrays.asList("counterparty2Name"), "[Not in regulation] Counterparty 2 name (DTCC)");
		startNode.addLabel(Arrays.asList("executionAgentCounterparty1"), "[Not in regulation] Execution agent of Counterparty 1 (DTCC)");
		startNode.addLabel(Arrays.asList("executionAgentCounterparty2"), "[Not in regulation] Execution agent of Counterparty 2 (DTCC)");
		startNode.addLabel(Arrays.asList("reportSubmittingEntityID"), "9 Data submitter");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifier"), "10 Unique Transaction Identifier (UTI)");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifierProprietary"), "10 Unique Transaction Identifier (Proprietary)");
		startNode.addLabel(Arrays.asList("priorUTIProprietary"), "12 Prior UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("uniqueProductIdentifier"), "11 Unique product identifier (UPI)");
		startNode.addLabel(Arrays.asList("contractType"), "13 Contract Type");
		startNode.addLabel(Arrays.asList("assetClass"), "14 Asset Class");
		startNode.addLabel(Arrays.asList("clearingTimestamp"), "42 Clearing Timestamp");
		startNode.addLabel(Arrays.asList("platformIdentifier"), "43 Platform Identifier");
		startNode.addLabel(Arrays.asList("direction1"), "5 Direction");
		startNode.addLabel(Arrays.asList("nameOfTheUnderlyingIndex"), "15.5 Name of the underlying index (DTCC)");
		startNode.addLabel(Arrays.asList("optionType"), "28 Option type");
		startNode.addLabel(Arrays.asList("optionStyle"), "29 Option Style");
		startNode.addLabel(Arrays.asList("deliveryType"), "35 Delivery Type");
		startNode.addLabel(Arrays.asList("bookingLocation"), "45 Booking location");
		startNode.addLabel(Arrays.asList("traderLocation"), "46 Trader location");
		startNode.addLabel(Arrays.asList("tradingCapacity"), "4 Trading Capacity Of Specified Person");
		startNode.addLabel(Arrays.asList("technicalRecordId"), "[Internal] Technical Record Id (ISO)");
		startNode.addLabel(Arrays.asList("initialMarginCollateralPortfolioCode"), "58.1 Initial margin collateral portfolio code (DTCC)");
		startNode.addLabel(Arrays.asList("variationMarginCollateralPortfolioCode"), "58.2 Variation margin collateral portfolio code (DTCC)");
		startNode.addLabel(Arrays.asList("confirmationTimestamp"), "48 Confirmation Timestamp");
		startNode.addLabel(Arrays.asList("swapLinkID"), "33 Swap link ID");
		startNode.addLabel(Arrays.asList("underlyingIdentification"), "15 Underlying");
		startNode.addLabel(Arrays.asList("underlyingIdentificationType"), "15.2 Underlying Identification Type (DTCC)");
		startNode.addLabel(Arrays.asList("nonReportable", "enrichment"), "Enrichment Data");
		startNode.addLabel(Arrays.asList("nonReportable", "preUpiData"), "Upi Pre-Enrichment Data");
		startNode.addLabel(Arrays.asList("nonReportable", "postUpiData"), "Upi Post-Enrichment Data");
		startNode.addLabel(Arrays.asList("tradingCapacityOfSpecifiedPerson"), "4 Trading Capacity Of Specified Person");
		startNode.addLabel(Arrays.asList("reportingSpecifiedPerson"), "8 Reporting specified person");
	}
}
