package drr.standards.iosco.cde.base.price.functions;

import cdm.base.datetime.DateRange;
import cdm.base.math.DatedValue;
import cdm.event.common.BusinessEvent;
import cdm.event.workflow.WorkflowStep;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceOperandEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ProductForEvent;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PriceOfEvent.PriceOfEventDefault.class)
public abstract class PriceOfEvent implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_Price_Monetary contract_Price_Monetary;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

	/**
	* @param reportableEvent 
	* @return amount 
	*/
	public BigDecimal evaluate(ReportableEvent reportableEvent) {
		BigDecimal amount = doEvaluate(reportableEvent);
		
		return amount;
	}

	protected abstract BigDecimal doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends PriceSchedule> price(ReportableEvent reportableEvent);

	protected abstract MapperS<Date> eventDate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends CalculationSchedule> schedule(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends SchedulePeriod> schedulePeriod(ReportableEvent reportableEvent);

	public static class PriceOfEventDefault extends PriceOfEvent {
		@Override
		protected BigDecimal doEvaluate(ReportableEvent reportableEvent) {
			BigDecimal amount = null;
			return assignOutput(amount, reportableEvent);
		}
		
		protected BigDecimal assignOutput(BigDecimal amount, ReportableEvent reportableEvent) {
			if (areEqual(price(reportableEvent).<PriceComposite>map("getComposite", priceSchedule -> priceSchedule.getComposite()).<PriceOperandEnum>map("getOperandType", priceComposite -> priceComposite.getOperandType()), MapperS.of(PriceOperandEnum.ACCRUED_INTEREST), CardinalityOperator.All).getOrDefault(false)) {
				amount = price(reportableEvent).<PriceComposite>map("getComposite", priceSchedule -> priceSchedule.getComposite()).<BigDecimal>map("getBaseValue", priceComposite -> priceComposite.getBaseValue()).get();
			} else if (exists(price(reportableEvent).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue())).getOrDefault(false)) {
				amount = price(reportableEvent).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get();
			} else if (exists(price(reportableEvent).<DatedValue>mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue())).getOrDefault(false)) {
				final MapperC<DatedValue> thenArg0 = price(reportableEvent).<DatedValue>mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue())
					.filterItemNullSafe(item -> areEqual(item.<Date>map("getDate", datedValue -> datedValue.getDate()), schedulePeriod(reportableEvent).<DateRange>map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()), CardinalityOperator.All).get());
				final MapperC<BigDecimal> thenArg1 = thenArg0
					.mapItem(item -> item.<BigDecimal>map("getValue", datedValue -> datedValue.getValue()));
				amount = MapperS.of(thenArg1.get()).get();
			} else {
				amount = null;
			}
			
			return amount;
		}
		
		@Override
		protected MapperS<? extends PriceSchedule> price(ReportableEvent reportableEvent) {
			return MapperS.of(MapperC.of(contract_Price_Monetary.evaluate(reportableEvent)).get());
		}
		
		@Override
		protected MapperS<Date> eventDate(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<Date>map("getEventDate", businessEvent -> businessEvent.getEventDate());
		}
		
		@Override
		protected MapperS<? extends CalculationSchedule> schedule(ReportableEvent reportableEvent) {
			if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent)))))).getOrDefault(false)) {
				return MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule())
					.first();
			}
			if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Option.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent)))))).getOrDefault(false)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<CalculationSchedule>map("getSchedule", optionPayout -> optionPayout.getSchedule());
			}
			final Boolean _boolean = qualify_Commodity_Forward.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent)));
			if ((_boolean == null ? false : _boolean)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<CalculationSchedule>map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
			}
			return MapperS.<CalculationSchedule>ofNull();
		}
		
		@Override
		protected MapperS<? extends SchedulePeriod> schedulePeriod(ReportableEvent reportableEvent) {
			if (lessThanEquals(eventDate(reportableEvent), schedule(reportableEvent).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<DateRange>map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate())
				.min(), CardinalityOperator.All).getOrDefault(false)) {
				return schedule(reportableEvent).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod())
					.min(item -> item.<DateRange>map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()));
			}
			if (greaterThanEquals(eventDate(reportableEvent), schedule(reportableEvent).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<DateRange>map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate())
				.max(), CardinalityOperator.All).getOrDefault(false)) {
				return schedule(reportableEvent).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod())
					.max(item -> item.<DateRange>map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()));
			}
			final MapperC<SchedulePeriod> thenArg0 = schedule(reportableEvent).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod());
			final MapperC<SchedulePeriod> thenArg1 = thenArg0
				.filterItemNullSafe(item -> lessThanEquals(item.<DateRange>map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()), eventDate(reportableEvent), CardinalityOperator.All).andNullSafe(greaterThanEquals(item.<DateRange>map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate()), eventDate(reportableEvent), CardinalityOperator.All)).get());
			return MapperS.of(thenArg1.get());
		}
	}
}
