package drr.standards.iosco.cde.version1.party.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.qualification.functions.Qualify_InterestRate_CapFloor;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.FXLeg2;
import drr.regulation.common.functions.FXSwapLeg2;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXSwap;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Direction2PayerPartyLeg2.Direction2PayerPartyLeg2Default.class)
public abstract class Direction2PayerPartyLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected ExtractCounterpartyByRole extractCounterpartyByRole;
	@Inject protected FXLeg2 fXLeg2;
	@Inject protected FXSwapLeg2 fXSwapLeg2;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_InterestRate_CapFloor qualify_InterestRate_CapFloor;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return party 
	*/
	public Party evaluate(ReportableEvent reportableEvent) {
		Party.PartyBuilder partyBuilder = doEvaluate(reportableEvent);
		
		final Party party;
		if (partyBuilder == null) {
			party = null;
		} else {
			party = partyBuilder.build();
			objectValidator.validate(Party.class, party);
		}
		
		return party;
	}

	protected abstract Party.PartyBuilder doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<CounterpartyRoleEnum> counterpartyRole(ReportableEvent reportableEvent);

	public static class Direction2PayerPartyLeg2Default extends Direction2PayerPartyLeg2 {
		@Override
		protected Party.PartyBuilder doEvaluate(ReportableEvent reportableEvent) {
			Party.PartyBuilder party = Party.builder();
			return assignOutput(party, reportableEvent);
		}
		
		protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, ReportableEvent reportableEvent) {
			final ReferenceWithMetaParty referenceWithMetaParty = MapperS.of(extractCounterpartyByRole.evaluate(MapperS.of(tradeForEvent.evaluate(reportableEvent)).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Counterparty>mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), counterpartyRole(reportableEvent).get())).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).get();
			if (referenceWithMetaParty == null) {
				party = null;
			} else {
				party = toBuilder(referenceWithMetaParty.getValue());
			}
			
			return Optional.ofNullable(party)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<CounterpartyRoleEnum> counterpartyRole(ReportableEvent reportableEvent) {
			final Boolean boolean0 = isCommoditySwap.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)));
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(commodityLeg2.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)))).<PayerReceiver>map("getPayerReceiver", commodityPayout -> commodityPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			final Boolean boolean1 = isFXForward.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)));
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(fXLeg2.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)))).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			final Boolean boolean2 = isFXSwap.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)));
			if ((boolean2 == null ? false : boolean2)) {
				return MapperS.of(fXSwapLeg2.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)))).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			if (areEqual(MapperS.of(qualify_InterestRate_Option_Swaption.evaluate(MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(qualify_InterestRate_CapFloor.evaluate(MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()))).getOrDefault(false)) {
				return MapperS.of(interestRateLeg2.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)))).<PayerReceiver>map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			return MapperS.<CounterpartyRoleEnum>ofNull();
		}
	}
}
