package drr.standards.iosco.cde.version1.party.reports;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_InterestRate_CapFloor;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.FXLeg1;
import drr.regulation.common.functions.FXSwapLeg1;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.IsCommoditySwapFixedFloat;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import drr.regulation.common.functions.IsCreditTotalReturnSwap;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXSwap;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.version1.party.functions.Direction2;
import drr.standards.iso.Direction2Enum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Direction2Leg1Rule.Direction2Leg1RuleDefault.class)
public abstract class Direction2Leg1Rule implements ReportFunction<TransactionReportInstruction, Direction2Enum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected Direction2 direction2;
	@Inject protected FXLeg1 fXLeg1;
	@Inject protected FXSwapLeg1 fXSwapLeg1;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
	@Inject protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
	@Inject protected IsCreditTotalReturnSwap isCreditTotalReturnSwap;
	@Inject protected IsEquity isEquity;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsVarianceSwap isVarianceSwap;
	@Inject protected IsVolatilitySwap isVolatilitySwap;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_InterestRate_CapFloor qualify_InterestRate_CapFloor;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Direction2Enum evaluate(TransactionReportInstruction input) {
		Direction2Enum output = doEvaluate(input);
		
		return output;
	}

	protected abstract Direction2Enum doEvaluate(TransactionReportInstruction input);

	public static class Direction2Leg1RuleDefault extends Direction2Leg1Rule {
		@Override
		protected Direction2Enum doEvaluate(TransactionReportInstruction input) {
			Direction2Enum output = null;
			return assignOutput(output, input);
		}
		
		protected Direction2Enum assignOutput(Direction2Enum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(direction2.evaluate(item.get(), MapperS.of(tradeForEvent.evaluate(item.get()))
					.mapSingleToItem(trade -> trade.<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct())
						.mapSingleToItem(_item -> {
							final Boolean boolean0 = isCommoditySwapFloatFloat.evaluate(_item.get());
							if ((boolean0 == null ? false : boolean0)) {
								return MapperS.of(commodityLeg1.evaluate(_item.get())).<PayerReceiver>map("getPayerReceiver", commodityPayout -> commodityPayout.getPayerReceiver());
							}
							final Boolean boolean1 = isCommoditySwapFixedFloat.evaluate(_item.get());
							if ((boolean1 == null ? false : boolean1)) {
								return MapperS.of(fixedPriceLeg1.evaluate(_item.get())).<PayerReceiver>map("getPayerReceiver", fixedPricePayout -> fixedPricePayout.getPayerReceiver());
							}
							if (ComparisonResult.ofNullSafe(MapperS.of(isEquity.evaluate(_item.get()))).andNullSafe(areEqual(ComparisonResult.ofNullSafe(MapperS.of(isVarianceSwap.evaluate(_item.get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isVolatilitySwap.evaluate(_item.get())))), MapperS.of(false), CardinalityOperator.All)).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCreditTotalReturnSwap.evaluate(_item.get())))).getOrDefault(false)) {
								return MapperS.of(_item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<PayerReceiver>map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver());
							}
							final Boolean boolean2 = isFXForward.evaluate(_item.get());
							if ((boolean2 == null ? false : boolean2)) {
								return MapperS.of(fXLeg1.evaluate(productForTrade.evaluate(trade.get()))).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver());
							}
							final Boolean boolean3 = isFXSwap.evaluate(_item.get());
							if ((boolean3 == null ? false : boolean3)) {
								return MapperS.of(fXSwapLeg1.evaluate(_item.get())).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver());
							}
							if (areEqual(MapperS.of(qualify_InterestRate_Option_Swaption.evaluate(_item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(qualify_InterestRate_CapFloor.evaluate(_item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All)).andNullSafe(areEqual(MapperS.of(qualify_AssetClass_Credit.evaluate(_item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
								return MapperS.of(interestRateLeg1.evaluate(_item.get())).<PayerReceiver>map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver());
							}
							return MapperS.<PayerReceiver>ofNull();
						})).get()))).get();
			
			return output;
		}
	}
}
