package drr.standards.iosco.cde.version1.party.reports;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_InterestRate_CapFloor;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.FXLeg2;
import drr.regulation.common.functions.FXSwapLeg2;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsCreditTotalReturnSwap;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXSwap;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.version1.party.functions.Direction2;
import drr.standards.iso.Direction2Enum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Direction2Leg2Rule.Direction2Leg2RuleDefault.class)
public abstract class Direction2Leg2Rule implements ReportFunction<TransactionReportInstruction, Direction2Enum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected Direction2 direction2;
	@Inject protected FXLeg2 fXLeg2;
	@Inject protected FXSwapLeg2 fXSwapLeg2;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsCreditTotalReturnSwap isCreditTotalReturnSwap;
	@Inject protected IsEquity isEquity;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsVarianceSwap isVarianceSwap;
	@Inject protected IsVolatilitySwap isVolatilitySwap;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_InterestRate_CapFloor qualify_InterestRate_CapFloor;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Direction2Enum evaluate(TransactionReportInstruction input) {
		Direction2Enum output = doEvaluate(input);
		
		return output;
	}

	protected abstract Direction2Enum doEvaluate(TransactionReportInstruction input);

	public static class Direction2Leg2RuleDefault extends Direction2Leg2Rule {
		@Override
		protected Direction2Enum doEvaluate(TransactionReportInstruction input) {
			Direction2Enum output = null;
			return assignOutput(output, input);
		}
		
		protected Direction2Enum assignOutput(Direction2Enum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					final MapperS<Product> thenArg = MapperS.of(tradeForEvent.evaluate(item.get())).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct());
					return MapperS.of(direction2.evaluate(item.get(), thenArg
						.mapSingleToItem(_item -> {
							final Boolean boolean0 = isCommoditySwap.evaluate(_item.get());
							if ((boolean0 == null ? false : boolean0)) {
								return MapperS.of(commodityLeg2.evaluate(_item.get())).<PayerReceiver>map("getPayerReceiver", commodityPayout -> commodityPayout.getPayerReceiver());
							}
							if (ComparisonResult.ofNullSafe(MapperS.of(isEquity.evaluate(_item.get()))).andNullSafe(areEqual(ComparisonResult.ofNullSafe(MapperS.of(isVarianceSwap.evaluate(_item.get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isVolatilitySwap.evaluate(_item.get())))), MapperS.of(false), CardinalityOperator.All)).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCreditTotalReturnSwap.evaluate(_item.get())))).getOrDefault(false)) {
								if (exists(MapperS.of(interestRateLeg2.evaluate(_item.get()))).getOrDefault(false)) {
									return MapperS.of(interestRateLeg2.evaluate(_item.get())).<PayerReceiver>map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver());
								}
								if (exists(_item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout())).getOrDefault(false)) {
									return MapperS.of(distinct(_item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).<PayerReceiver>map("getPayerReceiver", fixedPricePayout -> fixedPricePayout.getPayerReceiver())).get());
								}
								return MapperS.<PayerReceiver>ofNull();
							}
							final Boolean boolean1 = isFXForward.evaluate(_item.get());
							if ((boolean1 == null ? false : boolean1)) {
								return MapperS.of(fXLeg2.evaluate(_item.get())).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver());
							}
							final Boolean boolean2 = isFXSwap.evaluate(_item.get());
							if ((boolean2 == null ? false : boolean2)) {
								return MapperS.of(fXSwapLeg2.evaluate(_item.get())).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver());
							}
							if (areEqual(MapperS.of(qualify_InterestRate_Option_Swaption.evaluate(_item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(qualify_InterestRate_CapFloor.evaluate(_item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All)).andNullSafe(areEqual(MapperS.of(qualify_AssetClass_Credit.evaluate(_item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
								return MapperS.of(interestRateLeg2.evaluate(_item.get())).<PayerReceiver>map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver());
							}
							return MapperS.<PayerReceiver>ofNull();
						}).get()));
				}).get();
			
			return output;
		}
	}
}
