package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.standards.iosco.cde.base.price.functions.Contract_Price;
import drr.standards.iosco.cde.base.price.functions.Contract_StrikePrice;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ExchangeRateBasisRule.ExchangeRateBasisRuleDefault.class)
public abstract class ExchangeRateBasisRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_Price contract_Price;
	@Inject protected Contract_StrikePrice contract_StrikePrice;
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class ExchangeRateBasisRuleDefault extends ExchangeRateBasisRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperC<PriceSchedule> thenArg0 = MapperC.<PriceSchedule>of(MapperC.<PriceSchedule>of(contract_Price.evaluate(input)), MapperC.<PriceSchedule>of(contract_StrikePrice.evaluate(input)))
				.filterItemNullSafe(item -> areEqual(item.<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.EXCHANGE_RATE), CardinalityOperator.All).andNullSafe(notExists(item.<ArithmeticOperationEnum>map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
			final MapperS<PriceSchedule> thenArg1 = thenArg0
				.last();
			final FieldWithMetaString fieldWithMetaString0 = thenArg1.<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
			final FieldWithMetaString fieldWithMetaString1 = thenArg1.<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
			final MapperS<String> ifThenElseResult;
			if (exists(MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue())))).andNullSafe(exists(MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()))))).getOrDefault(false)) {
				final FieldWithMetaString fieldWithMetaString2 = thenArg1.<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
				final FieldWithMetaString fieldWithMetaString3 = thenArg1.<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
				ifThenElseResult = MapperMaths.<String, String, String>add(MapperMaths.<String, String, String>add(MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue()))).map("to-string", ISOCurrencyCodeEnum::toDisplayString), MapperS.of("/")), MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString3 == null ? null : fieldWithMetaString3.getValue()))).map("to-string", ISOCurrencyCodeEnum::toDisplayString));
			} else {
				ifThenElseResult = MapperS.<String>ofNull();
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
