package drr.standards.iosco.cde.version2.quantity.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountLeg1.NotionalAmountLeg1Default.class)
public abstract class NotionalAmountLeg1 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version1.quantity.functions.NotionalAmountLeg1 notionalAmountLeg1;

	/**
	* @param transactionReportInstruction 
	* @param defaultValue 
	* @return _notionalAmountLeg1 
	*/
	public BigDecimal evaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
		BigDecimal _notionalAmountLeg1 = doEvaluate(transactionReportInstruction, defaultValue);
		
		return _notionalAmountLeg1;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue);

	public static class NotionalAmountLeg1Default extends NotionalAmountLeg1 {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			BigDecimal _notionalAmountLeg1 = null;
			return assignOutput(_notionalAmountLeg1, transactionReportInstruction, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal _notionalAmountLeg1, TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			_notionalAmountLeg1 = notionalAmountLeg1.evaluate(transactionReportInstruction, defaultValue);
			
			return _notionalAmountLeg1;
		}
	}
}
