package iso20022.auth030.asic.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.Direction4Choice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("Direction4ChoiceChoice")
@ImplementedBy(Direction4ChoiceChoice.Default.class)
public interface Direction4ChoiceChoice extends Validator<Direction4Choice> {
	
	String NAME = "Direction4ChoiceChoice";
	String DEFINITION = "one-of";
	
	class Default implements Direction4ChoiceChoice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, Direction4Choice direction4Choice) {
			ComparisonResult result = executeDataRule(direction4Choice);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "Direction4Choice", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "Direction4Choice", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(Direction4Choice direction4Choice) {
			try {
				return choice(MapperS.of(direction4Choice), Arrays.asList("drctn", "ctrPtySd"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements Direction4ChoiceChoice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, Direction4Choice direction4Choice) {
			return Collections.emptyList();
		}
	}
}
