package iso20022.auth030.fca.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd20Amount;
import iso20022.auth030.fca.AmountAndDirection106__3;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class AmountAndDirection106__3OnlyExistsValidator implements ValidatorWithArg<AmountAndDirection106__3, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends AmountAndDirection106__3> ValidationResult<AmountAndDirection106__3> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("amt", ExistenceChecker.isSet((ActiveOrHistoricCurrencyAnd20Amount) o.getAmt()))
				.put("sgn", ExistenceChecker.isSet((Boolean) o.getSgn()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("AmountAndDirection106__3", ValidationResult.ValidationType.ONLY_EXISTS, "AmountAndDirection106__3", path, "");
		}
		return failure("AmountAndDirection106__3", ValidationResult.ValidationType.ONLY_EXISTS, "AmountAndDirection106__3", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
