/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.cache;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.regnosys.rosetta.cache.IRequestScopedCache;
import com.regnosys.rosetta.utils.EnvironmentUtil;
import jakarta.inject.Provider;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestScopedCache<K, V>
implements IRequestScopedCache<K, V> {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractRequestScopedCache.class);
    public static final String REQUEST_SCOPED_CACHE_ENABLED_VARIABLE_NAME = "ENABLE_REQUEST_SCOPED_CACHE";
    private static final boolean REQUEST_SCOPED_CACHE_ENABLED = EnvironmentUtil.getBooleanOrDefault("ENABLE_REQUEST_SCOPED_CACHE", true);
    private final Object NULL_ENTRY = new Object();
    private final Cache<K, Object> managedCache;

    public AbstractRequestScopedCache(CacheBuilder<Object, Object> managedCache) {
        this.managedCache = managedCache.build();
    }

    @Override
    public V get(K key, Provider<? extends V> loader) {
        Object result;
        if (!REQUEST_SCOPED_CACHE_ENABLED) {
            return (V)loader.get();
        }
        try {
            result = this.managedCache.get(key, () -> Objects.requireNonNullElse(loader.get(), this.NULL_ENTRY));
        }
        catch (ExecutionException e) {
            result = this.handleLoaderException(e);
        }
        if (result == this.NULL_ENTRY) {
            return null;
        }
        return result;
    }

    protected boolean has(K key) {
        return this.managedCache.getIfPresent(key) != null;
    }

    protected void put(K key, V value) {
        if (!REQUEST_SCOPED_CACHE_ENABLED) {
            return;
        }
        this.managedCache.put(key, Objects.requireNonNullElse(value, this.NULL_ENTRY));
    }

    @Override
    public void clear() {
        LOGGER.debug("Clearing cache {} with approximate size {}", (Object)this.getClass().getCanonicalName(), (Object)this.managedCache.size());
        this.managedCache.invalidateAll();
    }

    protected V handleLoaderException(ExecutionException e) {
        Throwable cause = e.getCause();
        Throwables.throwIfUnchecked((Throwable)cause);
        throw new RuntimeException(e);
    }
}

