/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.utils.BigDecimalInterval;
import com.regnosys.rosetta.utils.PositiveIntegerInterval;
import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.regex.Pattern;

public class TypeFactory {
    private final RBuiltinTypeService builtinTypes;

    @Inject
    public TypeFactory(RBuiltinTypeService builtinTypes) {
        this.builtinTypes = builtinTypes;
    }

    public RMetaAnnotatedType intWithNoMeta(Optional<Integer> digits, Optional<BigInteger> min, Optional<BigInteger> max) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedInt(digits, min, max));
    }

    public RMetaAnnotatedType intWithNoMeta(int digits, BigInteger min, BigInteger max) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedInt(digits, min, max));
    }

    public RMetaAnnotatedType intWithNoMeta(int digits, String min, String max) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedInt(digits, min, max));
    }

    public RAliasType constrainedInt(Optional<Integer> digits, Optional<BigInteger> min, Optional<BigInteger> max) {
        RNumberType refersTo = this.constrainedNumber(digits, Optional.of(0), min.map(BigDecimal::new), max.map(BigDecimal::new), Optional.empty());
        LinkedHashMap<String, RosettaValue> args = new LinkedHashMap<String, RosettaValue>(refersTo.getArguments());
        args.remove("fractionalDigits");
        args.remove("scale");
        return new RAliasType(this.builtinTypes.INT_FUNCTION, args, refersTo, new ArrayList<Condition>());
    }

    public RAliasType constrainedInt(int digits, BigInteger min, BigInteger max) {
        return this.constrainedInt(Optional.of(digits), Optional.of(min), Optional.of(max));
    }

    public RAliasType constrainedInt(int digits, String min, String max) {
        return this.constrainedInt(Optional.of(digits), Optional.of(new BigInteger(min)), Optional.of(new BigInteger(max)));
    }

    public RMetaAnnotatedType numberWithNoMeta(Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max, Optional<BigDecimal> scale) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedNumber(digits, fractionalDigits, min, max, scale));
    }

    public RMetaAnnotatedType numberWithNoMeta(Optional<Integer> digits, Optional<Integer> fractionalDigits, BigDecimalInterval interval, Optional<BigDecimal> scale) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedNumber(digits, fractionalDigits, interval, scale));
    }

    public RMetaAnnotatedType numberWithNoMeta(int digits, int fractionalDigits, BigDecimal min, BigDecimal max) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedNumber(digits, fractionalDigits, min, max));
    }

    public RMetaAnnotatedType numberWithNoMeta(int digits, int fractionalDigits, String min, String max) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedNumber(digits, fractionalDigits, min, max));
    }

    public RNumberType constrainedNumber(Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max, Optional<BigDecimal> scale) {
        return new RNumberType(digits, fractionalDigits, min, max, scale);
    }

    public RNumberType constrainedNumber(Optional<Integer> digits, Optional<Integer> fractionalDigits, BigDecimalInterval interval, Optional<BigDecimal> scale) {
        return new RNumberType(digits, fractionalDigits, interval, scale);
    }

    public RNumberType constrainedNumber(int digits, int fractionalDigits, BigDecimal min, BigDecimal max) {
        return this.constrainedNumber(Optional.of(digits), Optional.of(fractionalDigits), Optional.of(min), Optional.of(max), Optional.empty());
    }

    public RNumberType constrainedNumber(int digits, int fractionalDigits, String min, String max) {
        return this.constrainedNumber(Optional.of(digits), Optional.of(fractionalDigits), Optional.of(new BigDecimal(min)), Optional.of(new BigDecimal(max)), Optional.empty());
    }

    public RMetaAnnotatedType stringWithNoMeta(Optional<Integer> minLength, Optional<Integer> maxLength, Optional<Pattern> pattern) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedString(minLength, maxLength, pattern));
    }

    public RMetaAnnotatedType stringWithNoMeta(PositiveIntegerInterval interval, Optional<Pattern> pattern) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedString(interval, pattern));
    }

    public RMetaAnnotatedType stringWithNoMeta(int minLength, int maxLength) {
        return RMetaAnnotatedType.withNoMeta(this.constrainedString(minLength, maxLength));
    }

    public RStringType constrainedString(Optional<Integer> minLength, Optional<Integer> maxLength, Optional<Pattern> pattern) {
        return new RStringType(minLength, maxLength, pattern);
    }

    public RStringType constrainedString(PositiveIntegerInterval interval, Optional<Pattern> pattern) {
        return new RStringType(interval, pattern);
    }

    public RStringType constrainedString(int minLength, int maxLength) {
        return new RStringType(Optional.of(minLength), Optional.of(maxLength), Optional.empty());
    }
}

