/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.qualify;

import com.google.inject.Injector;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.qualify.QualifyResult;
import java.util.function.Function;
import javax.inject.Inject;

public interface QualifyFunctionFactory {
    public <T extends RosettaModelObject> Function<? super T, QualifyResult> create(Class<? extends IQualifyFunctionExtension<T>> var1);

    public static class Default
    implements QualifyFunctionFactory {
        @Inject
        Injector injector;

        @Override
        public <T extends RosettaModelObject> Function<? super T, QualifyResult> create(final Class<? extends IQualifyFunctionExtension<T>> clazz) {
            return new Function<T, QualifyResult>(){

                @Override
                public QualifyResult apply(T t) {
                    String funcName = clazz.getSimpleName();
                    ComparisonResult result = ComparisonResult.success();
                    if (injector == null) {
                        throw new IllegalArgumentException("Injector instance not available. Use @Inject to get an instance of QualifyFunctionFactory.Default");
                    }
                    IQualifyFunctionExtension functionExtension = (IQualifyFunctionExtension)injector.getInstance(clazz);
                    if (!functionExtension.evaluate(t).booleanValue()) {
                        result = ComparisonResult.failure(funcName + " returned false.");
                    }
                    String prefix = functionExtension.getNamePrefix() + "_";
                    String qualifiedName = funcName.replaceFirst(prefix, "");
                    return QualifyResult.builder().setName(qualifiedName).setExpressionResult(funcName, result).build();
                }
            };
        }
    }
}

