/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenterTime;
import cdm.base.datetime.DayOfWeekEnum;
import cdm.base.datetime.Period;
import cdm.base.datetime.meta.CalculationFrequencyMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CalculationFrequency", builder=CalculationFrequencyBuilderImpl.class, version="5.32.0")
@RuneDataType(value="CalculationFrequency", model="cdm", builder=CalculationFrequencyBuilderImpl.class, version="5.32.0")
public interface CalculationFrequency
extends RosettaModelObject {
    public static final CalculationFrequencyMeta metaData = new CalculationFrequencyMeta();

    public Period getPeriod();

    public BigDecimal getMonthOfYear();

    public BigDecimal getDayOfMonth();

    public DayOfWeekEnum getDayOfWeek();

    public BigDecimal getWeekOfMonth();

    public BigDecimal getOffsetDays();

    public BusinessCenterTime getDateLocation();

    public List<BusinessCenterEnum> getBusinessCenter();

    public CalculationFrequency build();

    public CalculationFrequencyBuilder toBuilder();

    public static CalculationFrequencyBuilder builder() {
        return new CalculationFrequencyBuilderImpl();
    }

    default public RosettaMetaData<? extends CalculationFrequency> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CalculationFrequency> getType() {
        return CalculationFrequency.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("period"), processor, Period.class, this.getPeriod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("monthOfYear"), BigDecimal.class, (Object)this.getMonthOfYear(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayOfMonth"), BigDecimal.class, (Object)this.getDayOfMonth(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, (Object)this.getDayOfWeek(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("weekOfMonth"), BigDecimal.class, (Object)this.getWeekOfMonth(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("offsetDays"), BigDecimal.class, (Object)this.getOffsetDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateLocation"), processor, BusinessCenterTime.class, this.getDateLocation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("businessCenter"), BusinessCenterEnum.class, this.getBusinessCenter(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CalculationFrequencyBuilderImpl
    implements CalculationFrequencyBuilder {
        protected Period.PeriodBuilder period;
        protected BigDecimal monthOfYear;
        protected BigDecimal dayOfMonth;
        protected DayOfWeekEnum dayOfWeek;
        protected BigDecimal weekOfMonth;
        protected BigDecimal offsetDays;
        protected BusinessCenterTime.BusinessCenterTimeBuilder dateLocation;
        protected List<BusinessCenterEnum> businessCenter = new ArrayList<BusinessCenterEnum>();

        @Override
        @RosettaAttribute(value="period", isRequired=true)
        @RuneAttribute(value="period", isRequired=true)
        public Period.PeriodBuilder getPeriod() {
            return this.period;
        }

        @Override
        public Period.PeriodBuilder getOrCreatePeriod() {
            Period.PeriodBuilder result = this.period != null ? this.period : (this.period = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="monthOfYear")
        @RuneAttribute(value="monthOfYear")
        public BigDecimal getMonthOfYear() {
            return this.monthOfYear;
        }

        @Override
        @RosettaAttribute(value="dayOfMonth")
        @RuneAttribute(value="dayOfMonth")
        public BigDecimal getDayOfMonth() {
            return this.dayOfMonth;
        }

        @Override
        @RosettaAttribute(value="dayOfWeek")
        @RuneAttribute(value="dayOfWeek")
        public DayOfWeekEnum getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        @RosettaAttribute(value="weekOfMonth")
        @RuneAttribute(value="weekOfMonth")
        public BigDecimal getWeekOfMonth() {
            return this.weekOfMonth;
        }

        @Override
        @RosettaAttribute(value="offsetDays", isRequired=true)
        @RuneAttribute(value="offsetDays", isRequired=true)
        public BigDecimal getOffsetDays() {
            return this.offsetDays;
        }

        @Override
        @RosettaAttribute(value="dateLocation", isRequired=true)
        @RuneAttribute(value="dateLocation", isRequired=true)
        public BusinessCenterTime.BusinessCenterTimeBuilder getDateLocation() {
            return this.dateLocation;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateDateLocation() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.dateLocation != null ? this.dateLocation : (this.dateLocation = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="businessCenter")
        @RuneAttribute(value="businessCenter")
        public List<BusinessCenterEnum> getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        @RosettaAttribute(value="period", isRequired=true)
        @RuneAttribute(value="period", isRequired=true)
        public CalculationFrequencyBuilder setPeriod(Period _period) {
            this.period = _period == null ? null : _period.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="monthOfYear")
        @RuneAttribute(value="monthOfYear")
        public CalculationFrequencyBuilder setMonthOfYear(BigDecimal _monthOfYear) {
            this.monthOfYear = _monthOfYear == null ? null : _monthOfYear;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayOfMonth")
        @RuneAttribute(value="dayOfMonth")
        public CalculationFrequencyBuilder setDayOfMonth(BigDecimal _dayOfMonth) {
            this.dayOfMonth = _dayOfMonth == null ? null : _dayOfMonth;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayOfWeek")
        @RuneAttribute(value="dayOfWeek")
        public CalculationFrequencyBuilder setDayOfWeek(DayOfWeekEnum _dayOfWeek) {
            this.dayOfWeek = _dayOfWeek == null ? null : _dayOfWeek;
            return this;
        }

        @Override
        @RosettaAttribute(value="weekOfMonth")
        @RuneAttribute(value="weekOfMonth")
        public CalculationFrequencyBuilder setWeekOfMonth(BigDecimal _weekOfMonth) {
            this.weekOfMonth = _weekOfMonth == null ? null : _weekOfMonth;
            return this;
        }

        @Override
        @RosettaAttribute(value="offsetDays", isRequired=true)
        @RuneAttribute(value="offsetDays", isRequired=true)
        public CalculationFrequencyBuilder setOffsetDays(BigDecimal _offsetDays) {
            this.offsetDays = _offsetDays == null ? null : _offsetDays;
            return this;
        }

        @Override
        @RosettaAttribute(value="dateLocation", isRequired=true)
        @RuneAttribute(value="dateLocation", isRequired=true)
        public CalculationFrequencyBuilder setDateLocation(BusinessCenterTime _dateLocation) {
            this.dateLocation = _dateLocation == null ? null : _dateLocation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCenter")
        @RuneAttribute(value="businessCenter")
        public CalculationFrequencyBuilder addBusinessCenter(BusinessCenterEnum _businessCenter) {
            if (_businessCenter != null) {
                this.businessCenter.add(_businessCenter);
            }
            return this;
        }

        @Override
        public CalculationFrequencyBuilder addBusinessCenter(BusinessCenterEnum _businessCenter, int idx) {
            this.getIndex(this.businessCenter, idx, () -> _businessCenter);
            return this;
        }

        @Override
        public CalculationFrequencyBuilder addBusinessCenter(List<BusinessCenterEnum> businessCenters) {
            if (businessCenters != null) {
                for (BusinessCenterEnum toAdd : businessCenters) {
                    this.businessCenter.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="businessCenter")
        public CalculationFrequencyBuilder setBusinessCenter(List<BusinessCenterEnum> businessCenters) {
            this.businessCenter = businessCenters == null ? new ArrayList<BusinessCenterEnum>() : (List)businessCenters.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculationFrequency build() {
            return new CalculationFrequencyImpl(this);
        }

        @Override
        public CalculationFrequencyBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculationFrequencyBuilder prune() {
            if (this.period != null && !this.period.prune().hasData()) {
                this.period = null;
            }
            if (this.dateLocation != null && !this.dateLocation.prune().hasData()) {
                this.dateLocation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPeriod() != null && this.getPeriod().hasData()) {
                return true;
            }
            if (this.getMonthOfYear() != null) {
                return true;
            }
            if (this.getDayOfMonth() != null) {
                return true;
            }
            if (this.getDayOfWeek() != null) {
                return true;
            }
            if (this.getWeekOfMonth() != null) {
                return true;
            }
            if (this.getOffsetDays() != null) {
                return true;
            }
            if (this.getDateLocation() != null && this.getDateLocation().hasData()) {
                return true;
            }
            return this.getBusinessCenter() != null && !this.getBusinessCenter().isEmpty();
        }

        public CalculationFrequencyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculationFrequencyBuilder o = (CalculationFrequencyBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriod(), (RosettaModelObjectBuilder)o.getPeriod(), this::setPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateLocation(), (RosettaModelObjectBuilder)o.getDateLocation(), this::setDateLocation);
            merger.mergeBasic((Object)this.getMonthOfYear(), (Object)o.getMonthOfYear(), this::setMonthOfYear, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayOfMonth(), (Object)o.getDayOfMonth(), this::setDayOfMonth, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayOfWeek(), (Object)o.getDayOfWeek(), this::setDayOfWeek, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWeekOfMonth(), (Object)o.getWeekOfMonth(), this::setWeekOfMonth, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOffsetDays(), (Object)o.getOffsetDays(), this::setOffsetDays, new AttributeMeta[0]);
            merger.mergeBasic(this.getBusinessCenter(), o.getBusinessCenter(), this::addBusinessCenter);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculationFrequency _that = this.getType().cast(o);
            if (!Objects.equals(this.period, _that.getPeriod())) {
                return false;
            }
            if (!Objects.equals(this.monthOfYear, _that.getMonthOfYear())) {
                return false;
            }
            if (!Objects.equals(this.dayOfMonth, _that.getDayOfMonth())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayOfWeek, (Object)_that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals(this.weekOfMonth, _that.getWeekOfMonth())) {
                return false;
            }
            if (!Objects.equals(this.offsetDays, _that.getOffsetDays())) {
                return false;
            }
            if (!Objects.equals(this.dateLocation, _that.getDateLocation())) {
                return false;
            }
            return ListEquals.listEquals(this.businessCenter, _that.getBusinessCenter());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.period != null ? this.period.hashCode() : 0);
            _result = 31 * _result + (this.monthOfYear != null ? this.monthOfYear.hashCode() : 0);
            _result = 31 * _result + (this.dayOfMonth != null ? this.dayOfMonth.hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? ((Object)((Object)this.dayOfWeek)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.weekOfMonth != null ? this.weekOfMonth.hashCode() : 0);
            _result = 31 * _result + (this.offsetDays != null ? this.offsetDays.hashCode() : 0);
            _result = 31 * _result + (this.dateLocation != null ? this.dateLocation.hashCode() : 0);
            _result = 31 * _result + (this.businessCenter != null ? this.businessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "CalculationFrequencyBuilder {period=" + this.period + ", monthOfYear=" + this.monthOfYear + ", dayOfMonth=" + this.dayOfMonth + ", dayOfWeek=" + (Object)((Object)this.dayOfWeek) + ", weekOfMonth=" + this.weekOfMonth + ", offsetDays=" + this.offsetDays + ", dateLocation=" + this.dateLocation + ", businessCenter=" + this.businessCenter + '}';
        }
    }

    public static interface CalculationFrequencyBuilder
    extends CalculationFrequency,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreatePeriod();

        @Override
        public Period.PeriodBuilder getPeriod();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateDateLocation();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getDateLocation();

        public CalculationFrequencyBuilder setPeriod(Period var1);

        public CalculationFrequencyBuilder setMonthOfYear(BigDecimal var1);

        public CalculationFrequencyBuilder setDayOfMonth(BigDecimal var1);

        public CalculationFrequencyBuilder setDayOfWeek(DayOfWeekEnum var1);

        public CalculationFrequencyBuilder setWeekOfMonth(BigDecimal var1);

        public CalculationFrequencyBuilder setOffsetDays(BigDecimal var1);

        public CalculationFrequencyBuilder setDateLocation(BusinessCenterTime var1);

        public CalculationFrequencyBuilder addBusinessCenter(BusinessCenterEnum var1);

        public CalculationFrequencyBuilder addBusinessCenter(BusinessCenterEnum var1, int var2);

        public CalculationFrequencyBuilder addBusinessCenter(List<BusinessCenterEnum> var1);

        public CalculationFrequencyBuilder setBusinessCenter(List<BusinessCenterEnum> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("period"), processor, Period.PeriodBuilder.class, this.getPeriod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("monthOfYear"), BigDecimal.class, (Object)this.getMonthOfYear(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayOfMonth"), BigDecimal.class, (Object)this.getDayOfMonth(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, (Object)this.getDayOfWeek(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("weekOfMonth"), BigDecimal.class, (Object)this.getWeekOfMonth(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("offsetDays"), BigDecimal.class, (Object)this.getOffsetDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateLocation"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getDateLocation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("businessCenter"), BusinessCenterEnum.class, this.getBusinessCenter(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CalculationFrequencyBuilder prune();
    }

    public static class CalculationFrequencyImpl
    implements CalculationFrequency {
        private final Period period;
        private final BigDecimal monthOfYear;
        private final BigDecimal dayOfMonth;
        private final DayOfWeekEnum dayOfWeek;
        private final BigDecimal weekOfMonth;
        private final BigDecimal offsetDays;
        private final BusinessCenterTime dateLocation;
        private final List<BusinessCenterEnum> businessCenter;

        protected CalculationFrequencyImpl(CalculationFrequencyBuilder builder) {
            this.period = Optional.ofNullable(builder.getPeriod()).map(f -> f.build()).orElse(null);
            this.monthOfYear = builder.getMonthOfYear();
            this.dayOfMonth = builder.getDayOfMonth();
            this.dayOfWeek = builder.getDayOfWeek();
            this.weekOfMonth = builder.getWeekOfMonth();
            this.offsetDays = builder.getOffsetDays();
            this.dateLocation = Optional.ofNullable(builder.getDateLocation()).map(f -> f.build()).orElse(null);
            this.businessCenter = Optional.ofNullable(builder.getBusinessCenter()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="period", isRequired=true)
        @RuneAttribute(value="period", isRequired=true)
        public Period getPeriod() {
            return this.period;
        }

        @Override
        @RosettaAttribute(value="monthOfYear")
        @RuneAttribute(value="monthOfYear")
        public BigDecimal getMonthOfYear() {
            return this.monthOfYear;
        }

        @Override
        @RosettaAttribute(value="dayOfMonth")
        @RuneAttribute(value="dayOfMonth")
        public BigDecimal getDayOfMonth() {
            return this.dayOfMonth;
        }

        @Override
        @RosettaAttribute(value="dayOfWeek")
        @RuneAttribute(value="dayOfWeek")
        public DayOfWeekEnum getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        @RosettaAttribute(value="weekOfMonth")
        @RuneAttribute(value="weekOfMonth")
        public BigDecimal getWeekOfMonth() {
            return this.weekOfMonth;
        }

        @Override
        @RosettaAttribute(value="offsetDays", isRequired=true)
        @RuneAttribute(value="offsetDays", isRequired=true)
        public BigDecimal getOffsetDays() {
            return this.offsetDays;
        }

        @Override
        @RosettaAttribute(value="dateLocation", isRequired=true)
        @RuneAttribute(value="dateLocation", isRequired=true)
        public BusinessCenterTime getDateLocation() {
            return this.dateLocation;
        }

        @Override
        @RosettaAttribute(value="businessCenter")
        @RuneAttribute(value="businessCenter")
        public List<BusinessCenterEnum> getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        public CalculationFrequency build() {
            return this;
        }

        @Override
        public CalculationFrequencyBuilder toBuilder() {
            CalculationFrequencyBuilder builder = CalculationFrequency.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculationFrequencyBuilder builder) {
            Optional.ofNullable(this.getPeriod()).ifPresent(builder::setPeriod);
            Optional.ofNullable(this.getMonthOfYear()).ifPresent(builder::setMonthOfYear);
            Optional.ofNullable(this.getDayOfMonth()).ifPresent(builder::setDayOfMonth);
            Optional.ofNullable(this.getDayOfWeek()).ifPresent(builder::setDayOfWeek);
            Optional.ofNullable(this.getWeekOfMonth()).ifPresent(builder::setWeekOfMonth);
            Optional.ofNullable(this.getOffsetDays()).ifPresent(builder::setOffsetDays);
            Optional.ofNullable(this.getDateLocation()).ifPresent(builder::setDateLocation);
            Optional.ofNullable(this.getBusinessCenter()).ifPresent(builder::setBusinessCenter);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculationFrequency _that = this.getType().cast(o);
            if (!Objects.equals(this.period, _that.getPeriod())) {
                return false;
            }
            if (!Objects.equals(this.monthOfYear, _that.getMonthOfYear())) {
                return false;
            }
            if (!Objects.equals(this.dayOfMonth, _that.getDayOfMonth())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayOfWeek, (Object)_that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals(this.weekOfMonth, _that.getWeekOfMonth())) {
                return false;
            }
            if (!Objects.equals(this.offsetDays, _that.getOffsetDays())) {
                return false;
            }
            if (!Objects.equals(this.dateLocation, _that.getDateLocation())) {
                return false;
            }
            return ListEquals.listEquals(this.businessCenter, _that.getBusinessCenter());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.period != null ? this.period.hashCode() : 0);
            _result = 31 * _result + (this.monthOfYear != null ? this.monthOfYear.hashCode() : 0);
            _result = 31 * _result + (this.dayOfMonth != null ? this.dayOfMonth.hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? ((Object)((Object)this.dayOfWeek)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.weekOfMonth != null ? this.weekOfMonth.hashCode() : 0);
            _result = 31 * _result + (this.offsetDays != null ? this.offsetDays.hashCode() : 0);
            _result = 31 * _result + (this.dateLocation != null ? this.dateLocation.hashCode() : 0);
            _result = 31 * _result + (this.businessCenter != null ? this.businessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "CalculationFrequency {period=" + this.period + ", monthOfYear=" + this.monthOfYear + ", dayOfMonth=" + this.dayOfMonth + ", dayOfWeek=" + (Object)((Object)this.dayOfWeek) + ", weekOfMonth=" + this.weekOfMonth + ", offsetDays=" + this.offsetDays + ", dateLocation=" + this.dateLocation + ", businessCenter=" + this.businessCenter + '}';
        }
    }
}

