/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.validation.datarule;

import cdm.base.datetime.Period;
import cdm.base.datetime.PeriodEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PeriodDayPeriod")
@ImplementedBy(value=Default.class)
public interface PeriodDayPeriod
extends Validator<Period> {
    public static final String NAME = "PeriodDayPeriod";
    public static final String DEFINITION = "if periodMultiplier = 0 then period = PeriodEnum -> D";

    public static class NoOp
    implements PeriodDayPeriod {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Period period) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PeriodDayPeriod {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Period period) {
            ComparisonResult result = this.executeDataRule(period);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PeriodDayPeriod.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Period", (RosettaPath)path, (String)PeriodDayPeriod.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PeriodDayPeriod.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Period", (RosettaPath)path, (String)PeriodDayPeriod.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Period period) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)period).map("getPeriodMultiplier", _period -> _period.getPeriodMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)period).map("getPeriod", _period -> _period.getPeriod()), (Mapper)MapperS.of((Object)((Object)PeriodEnum.D)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

