/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party;

import cdm.base.staticdata.party.Address;
import cdm.base.staticdata.party.TelephoneNumber;
import cdm.base.staticdata.party.meta.ContactInformationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ContactInformation", builder=ContactInformationBuilderImpl.class, version="5.32.0")
@RuneDataType(value="ContactInformation", model="cdm", builder=ContactInformationBuilderImpl.class, version="5.32.0")
public interface ContactInformation
extends RosettaModelObject {
    public static final ContactInformationMeta metaData = new ContactInformationMeta();

    public List<? extends TelephoneNumber> getTelephone();

    public List<? extends Address> getAddress();

    public List<String> getEmail();

    public List<String> getWebPage();

    public ContactInformation build();

    public ContactInformationBuilder toBuilder();

    public static ContactInformationBuilder builder() {
        return new ContactInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends ContactInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ContactInformation> getType() {
        return ContactInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("telephone"), processor, TelephoneNumber.class, this.getTelephone(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("address"), processor, Address.class, this.getAddress(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("email"), String.class, this.getEmail(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("webPage"), String.class, this.getWebPage(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ContactInformationBuilderImpl
    implements ContactInformationBuilder {
        protected List<TelephoneNumber.TelephoneNumberBuilder> telephone = new ArrayList<TelephoneNumber.TelephoneNumberBuilder>();
        protected List<Address.AddressBuilder> address = new ArrayList<Address.AddressBuilder>();
        protected List<String> email = new ArrayList<String>();
        protected List<String> webPage = new ArrayList<String>();

        @Override
        @RosettaAttribute(value="telephone")
        @RuneAttribute(value="telephone")
        public List<? extends TelephoneNumber.TelephoneNumberBuilder> getTelephone() {
            return this.telephone;
        }

        @Override
        public TelephoneNumber.TelephoneNumberBuilder getOrCreateTelephone(int index) {
            if (this.telephone == null) {
                this.telephone = new ArrayList<TelephoneNumber.TelephoneNumberBuilder>();
            }
            return (TelephoneNumber.TelephoneNumberBuilder)this.getIndex(this.telephone, index, () -> {
                TelephoneNumber.TelephoneNumberBuilder newTelephone = TelephoneNumber.builder();
                return newTelephone;
            });
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="address")
        public List<? extends Address.AddressBuilder> getAddress() {
            return this.address;
        }

        @Override
        public Address.AddressBuilder getOrCreateAddress(int index) {
            if (this.address == null) {
                this.address = new ArrayList<Address.AddressBuilder>();
            }
            return (Address.AddressBuilder)this.getIndex(this.address, index, () -> {
                Address.AddressBuilder newAddress = Address.builder();
                return newAddress;
            });
        }

        @Override
        @RosettaAttribute(value="email")
        @RuneAttribute(value="email")
        public List<String> getEmail() {
            return this.email;
        }

        @Override
        @RosettaAttribute(value="webPage")
        @RuneAttribute(value="webPage")
        public List<String> getWebPage() {
            return this.webPage;
        }

        @Override
        @RosettaAttribute(value="telephone")
        @RuneAttribute(value="telephone")
        public ContactInformationBuilder addTelephone(TelephoneNumber _telephone) {
            if (_telephone != null) {
                this.telephone.add(_telephone.toBuilder());
            }
            return this;
        }

        @Override
        public ContactInformationBuilder addTelephone(TelephoneNumber _telephone, int idx) {
            this.getIndex(this.telephone, idx, () -> _telephone.toBuilder());
            return this;
        }

        @Override
        public ContactInformationBuilder addTelephone(List<? extends TelephoneNumber> telephones) {
            if (telephones != null) {
                for (TelephoneNumber telephoneNumber : telephones) {
                    this.telephone.add(telephoneNumber.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="telephone")
        public ContactInformationBuilder setTelephone(List<? extends TelephoneNumber> telephones) {
            this.telephone = telephones == null ? new ArrayList<TelephoneNumber.TelephoneNumberBuilder>() : (List)telephones.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="address")
        public ContactInformationBuilder addAddress(Address _address) {
            if (_address != null) {
                this.address.add(_address.toBuilder());
            }
            return this;
        }

        @Override
        public ContactInformationBuilder addAddress(Address _address, int idx) {
            this.getIndex(this.address, idx, () -> _address.toBuilder());
            return this;
        }

        @Override
        public ContactInformationBuilder addAddress(List<? extends Address> addresss) {
            if (addresss != null) {
                for (Address address : addresss) {
                    this.address.add(address.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="address")
        public ContactInformationBuilder setAddress(List<? extends Address> addresss) {
            this.address = addresss == null ? new ArrayList<Address.AddressBuilder>() : (List)addresss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="email")
        @RuneAttribute(value="email")
        public ContactInformationBuilder addEmail(String _email) {
            if (_email != null) {
                this.email.add(_email);
            }
            return this;
        }

        @Override
        public ContactInformationBuilder addEmail(String _email, int idx) {
            this.getIndex(this.email, idx, () -> _email);
            return this;
        }

        @Override
        public ContactInformationBuilder addEmail(List<String> emails) {
            if (emails != null) {
                for (String toAdd : emails) {
                    this.email.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="email")
        public ContactInformationBuilder setEmail(List<String> emails) {
            this.email = emails == null ? new ArrayList<String>() : (List)emails.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="webPage")
        @RuneAttribute(value="webPage")
        public ContactInformationBuilder addWebPage(String _webPage) {
            if (_webPage != null) {
                this.webPage.add(_webPage);
            }
            return this;
        }

        @Override
        public ContactInformationBuilder addWebPage(String _webPage, int idx) {
            this.getIndex(this.webPage, idx, () -> _webPage);
            return this;
        }

        @Override
        public ContactInformationBuilder addWebPage(List<String> webPages) {
            if (webPages != null) {
                for (String toAdd : webPages) {
                    this.webPage.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="webPage")
        public ContactInformationBuilder setWebPage(List<String> webPages) {
            this.webPage = webPages == null ? new ArrayList<String>() : (List)webPages.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ContactInformation build() {
            return new ContactInformationImpl(this);
        }

        @Override
        public ContactInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public ContactInformationBuilder prune() {
            this.telephone = this.telephone.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.address = this.address.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getTelephone() != null && this.getTelephone().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAddress() != null && this.getAddress().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getEmail() != null && !this.getEmail().isEmpty()) {
                return true;
            }
            return this.getWebPage() != null && !this.getWebPage().isEmpty();
        }

        public ContactInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ContactInformationBuilder o = (ContactInformationBuilder)other;
            merger.mergeRosetta(this.getTelephone(), o.getTelephone(), this::getOrCreateTelephone);
            merger.mergeRosetta(this.getAddress(), o.getAddress(), this::getOrCreateAddress);
            merger.mergeBasic(this.getEmail(), o.getEmail(), this::addEmail);
            merger.mergeBasic(this.getWebPage(), o.getWebPage(), this::addWebPage);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ContactInformation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.telephone, _that.getTelephone())) {
                return false;
            }
            if (!ListEquals.listEquals(this.address, _that.getAddress())) {
                return false;
            }
            if (!ListEquals.listEquals(this.email, _that.getEmail())) {
                return false;
            }
            return ListEquals.listEquals(this.webPage, _that.getWebPage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.telephone != null ? this.telephone.hashCode() : 0);
            _result = 31 * _result + (this.address != null ? this.address.hashCode() : 0);
            _result = 31 * _result + (this.email != null ? this.email.hashCode() : 0);
            _result = 31 * _result + (this.webPage != null ? this.webPage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ContactInformationBuilder {telephone=" + this.telephone + ", address=" + this.address + ", email=" + this.email + ", webPage=" + this.webPage + '}';
        }
    }

    public static interface ContactInformationBuilder
    extends ContactInformation,
    RosettaModelObjectBuilder {
        public TelephoneNumber.TelephoneNumberBuilder getOrCreateTelephone(int var1);

        public List<? extends TelephoneNumber.TelephoneNumberBuilder> getTelephone();

        public Address.AddressBuilder getOrCreateAddress(int var1);

        public List<? extends Address.AddressBuilder> getAddress();

        public ContactInformationBuilder addTelephone(TelephoneNumber var1);

        public ContactInformationBuilder addTelephone(TelephoneNumber var1, int var2);

        public ContactInformationBuilder addTelephone(List<? extends TelephoneNumber> var1);

        public ContactInformationBuilder setTelephone(List<? extends TelephoneNumber> var1);

        public ContactInformationBuilder addAddress(Address var1);

        public ContactInformationBuilder addAddress(Address var1, int var2);

        public ContactInformationBuilder addAddress(List<? extends Address> var1);

        public ContactInformationBuilder setAddress(List<? extends Address> var1);

        public ContactInformationBuilder addEmail(String var1);

        public ContactInformationBuilder addEmail(String var1, int var2);

        public ContactInformationBuilder addEmail(List<String> var1);

        public ContactInformationBuilder setEmail(List<String> var1);

        public ContactInformationBuilder addWebPage(String var1);

        public ContactInformationBuilder addWebPage(String var1, int var2);

        public ContactInformationBuilder addWebPage(List<String> var1);

        public ContactInformationBuilder setWebPage(List<String> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("telephone"), processor, TelephoneNumber.TelephoneNumberBuilder.class, this.getTelephone(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("address"), processor, Address.AddressBuilder.class, this.getAddress(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("email"), String.class, this.getEmail(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("webPage"), String.class, this.getWebPage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ContactInformationBuilder prune();
    }

    public static class ContactInformationImpl
    implements ContactInformation {
        private final List<? extends TelephoneNumber> telephone;
        private final List<? extends Address> address;
        private final List<String> email;
        private final List<String> webPage;

        protected ContactInformationImpl(ContactInformationBuilder builder) {
            this.telephone = Optional.ofNullable(builder.getTelephone()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.address = Optional.ofNullable(builder.getAddress()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.email = Optional.ofNullable(builder.getEmail()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.webPage = Optional.ofNullable(builder.getWebPage()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="telephone")
        @RuneAttribute(value="telephone")
        public List<? extends TelephoneNumber> getTelephone() {
            return this.telephone;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="address")
        public List<? extends Address> getAddress() {
            return this.address;
        }

        @Override
        @RosettaAttribute(value="email")
        @RuneAttribute(value="email")
        public List<String> getEmail() {
            return this.email;
        }

        @Override
        @RosettaAttribute(value="webPage")
        @RuneAttribute(value="webPage")
        public List<String> getWebPage() {
            return this.webPage;
        }

        @Override
        public ContactInformation build() {
            return this;
        }

        @Override
        public ContactInformationBuilder toBuilder() {
            ContactInformationBuilder builder = ContactInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ContactInformationBuilder builder) {
            Optional.ofNullable(this.getTelephone()).ifPresent(builder::setTelephone);
            Optional.ofNullable(this.getAddress()).ifPresent(builder::setAddress);
            Optional.ofNullable(this.getEmail()).ifPresent(builder::setEmail);
            Optional.ofNullable(this.getWebPage()).ifPresent(builder::setWebPage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ContactInformation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.telephone, _that.getTelephone())) {
                return false;
            }
            if (!ListEquals.listEquals(this.address, _that.getAddress())) {
                return false;
            }
            if (!ListEquals.listEquals(this.email, _that.getEmail())) {
                return false;
            }
            return ListEquals.listEquals(this.webPage, _that.getWebPage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.telephone != null ? this.telephone.hashCode() : 0);
            _result = 31 * _result + (this.address != null ? this.address.hashCode() : 0);
            _result = 31 * _result + (this.email != null ? this.email.hashCode() : 0);
            _result = 31 * _result + (this.webPage != null ? this.webPage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ContactInformation {telephone=" + this.telephone + ", address=" + this.address + ", email=" + this.email + ", webPage=" + this.webPage + '}';
        }
    }
}

