/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.event.common.CollateralStatusEnum;
import cdm.event.common.HaircutIndicatorEnum;
import cdm.event.common.meta.CollateralBalanceMeta;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CollateralBalance", builder=CollateralBalanceBuilderImpl.class, version="5.32.0")
@RuneDataType(value="CollateralBalance", model="cdm", builder=CollateralBalanceBuilderImpl.class, version="5.32.0")
public interface CollateralBalance
extends RosettaModelObject {
    public static final CollateralBalanceMeta metaData = new CollateralBalanceMeta();

    public CollateralStatusEnum getCollateralBalanceStatus();

    public HaircutIndicatorEnum getHaircutIndicator();

    public Money getAmountBaseCurrency();

    public PartyReferencePayerReceiver getPayerReceiver();

    public CollateralBalance build();

    public CollateralBalanceBuilder toBuilder();

    public static CollateralBalanceBuilder builder() {
        return new CollateralBalanceBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralBalance> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralBalance> getType() {
        return CollateralBalance.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("collateralBalanceStatus"), CollateralStatusEnum.class, (Object)this.getCollateralBalanceStatus(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("haircutIndicator"), HaircutIndicatorEnum.class, (Object)this.getHaircutIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amountBaseCurrency"), processor, Money.class, this.getAmountBaseCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PartyReferencePayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
    }

    public static class CollateralBalanceBuilderImpl
    implements CollateralBalanceBuilder {
        protected CollateralStatusEnum collateralBalanceStatus;
        protected HaircutIndicatorEnum haircutIndicator;
        protected Money.MoneyBuilder amountBaseCurrency;
        protected PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder payerReceiver;

        @Override
        @RosettaAttribute(value="collateralBalanceStatus")
        @RuneAttribute(value="collateralBalanceStatus")
        public CollateralStatusEnum getCollateralBalanceStatus() {
            return this.collateralBalanceStatus;
        }

        @Override
        @RosettaAttribute(value="haircutIndicator")
        @RuneAttribute(value="haircutIndicator")
        public HaircutIndicatorEnum getHaircutIndicator() {
            return this.haircutIndicator;
        }

        @Override
        @RosettaAttribute(value="amountBaseCurrency", isRequired=true)
        @RuneAttribute(value="amountBaseCurrency", isRequired=true)
        public Money.MoneyBuilder getAmountBaseCurrency() {
            return this.amountBaseCurrency;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAmountBaseCurrency() {
            Money.MoneyBuilder result = this.amountBaseCurrency != null ? this.amountBaseCurrency : (this.amountBaseCurrency = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getOrCreatePayerReceiver() {
            PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder result = this.payerReceiver != null ? this.payerReceiver : (this.payerReceiver = PartyReferencePayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralBalanceStatus")
        @RuneAttribute(value="collateralBalanceStatus")
        public CollateralBalanceBuilder setCollateralBalanceStatus(CollateralStatusEnum _collateralBalanceStatus) {
            this.collateralBalanceStatus = _collateralBalanceStatus == null ? null : _collateralBalanceStatus;
            return this;
        }

        @Override
        @RosettaAttribute(value="haircutIndicator")
        @RuneAttribute(value="haircutIndicator")
        public CollateralBalanceBuilder setHaircutIndicator(HaircutIndicatorEnum _haircutIndicator) {
            this.haircutIndicator = _haircutIndicator == null ? null : _haircutIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="amountBaseCurrency", isRequired=true)
        @RuneAttribute(value="amountBaseCurrency", isRequired=true)
        public CollateralBalanceBuilder setAmountBaseCurrency(Money _amountBaseCurrency) {
            this.amountBaseCurrency = _amountBaseCurrency == null ? null : _amountBaseCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public CollateralBalanceBuilder setPayerReceiver(PartyReferencePayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        public CollateralBalance build() {
            return new CollateralBalanceImpl(this);
        }

        @Override
        public CollateralBalanceBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralBalanceBuilder prune() {
            if (this.amountBaseCurrency != null && !this.amountBaseCurrency.prune().hasData()) {
                this.amountBaseCurrency = null;
            }
            if (this.payerReceiver != null && !this.payerReceiver.prune().hasData()) {
                this.payerReceiver = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCollateralBalanceStatus() != null) {
                return true;
            }
            if (this.getHaircutIndicator() != null) {
                return true;
            }
            if (this.getAmountBaseCurrency() != null && this.getAmountBaseCurrency().hasData()) {
                return true;
            }
            return this.getPayerReceiver() != null && this.getPayerReceiver().hasData();
        }

        public CollateralBalanceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralBalanceBuilder o = (CollateralBalanceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmountBaseCurrency(), (RosettaModelObjectBuilder)o.getAmountBaseCurrency(), this::setAmountBaseCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiver(), (RosettaModelObjectBuilder)o.getPayerReceiver(), this::setPayerReceiver);
            merger.mergeBasic((Object)this.getCollateralBalanceStatus(), (Object)o.getCollateralBalanceStatus(), this::setCollateralBalanceStatus, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getHaircutIndicator(), (Object)o.getHaircutIndicator(), this::setHaircutIndicator, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralBalance _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.collateralBalanceStatus, (Object)_that.getCollateralBalanceStatus())) {
                return false;
            }
            if (!Objects.equals((Object)this.haircutIndicator, (Object)_that.getHaircutIndicator())) {
                return false;
            }
            if (!Objects.equals(this.amountBaseCurrency, _that.getAmountBaseCurrency())) {
                return false;
            }
            return Objects.equals(this.payerReceiver, _that.getPayerReceiver());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralBalanceStatus != null ? ((Object)((Object)this.collateralBalanceStatus)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.haircutIndicator != null ? ((Object)((Object)this.haircutIndicator)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amountBaseCurrency != null ? this.amountBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralBalanceBuilder {collateralBalanceStatus=" + (Object)((Object)this.collateralBalanceStatus) + ", haircutIndicator=" + (Object)((Object)this.haircutIndicator) + ", amountBaseCurrency=" + this.amountBaseCurrency + ", payerReceiver=" + this.payerReceiver + '}';
        }
    }

    public static interface CollateralBalanceBuilder
    extends CollateralBalance,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateAmountBaseCurrency();

        @Override
        public Money.MoneyBuilder getAmountBaseCurrency();

        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getOrCreatePayerReceiver();

        @Override
        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getPayerReceiver();

        public CollateralBalanceBuilder setCollateralBalanceStatus(CollateralStatusEnum var1);

        public CollateralBalanceBuilder setHaircutIndicator(HaircutIndicatorEnum var1);

        public CollateralBalanceBuilder setAmountBaseCurrency(Money var1);

        public CollateralBalanceBuilder setPayerReceiver(PartyReferencePayerReceiver var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("collateralBalanceStatus"), CollateralStatusEnum.class, (Object)this.getCollateralBalanceStatus(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("haircutIndicator"), HaircutIndicatorEnum.class, (Object)this.getHaircutIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amountBaseCurrency"), processor, Money.MoneyBuilder.class, this.getAmountBaseCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder.class, this.getPayerReceiver(), new AttributeMeta[0]);
        }

        public CollateralBalanceBuilder prune();
    }

    public static class CollateralBalanceImpl
    implements CollateralBalance {
        private final CollateralStatusEnum collateralBalanceStatus;
        private final HaircutIndicatorEnum haircutIndicator;
        private final Money amountBaseCurrency;
        private final PartyReferencePayerReceiver payerReceiver;

        protected CollateralBalanceImpl(CollateralBalanceBuilder builder) {
            this.collateralBalanceStatus = builder.getCollateralBalanceStatus();
            this.haircutIndicator = builder.getHaircutIndicator();
            this.amountBaseCurrency = Optional.ofNullable(builder.getAmountBaseCurrency()).map(f -> f.build()).orElse(null);
            this.payerReceiver = Optional.ofNullable(builder.getPayerReceiver()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="collateralBalanceStatus")
        @RuneAttribute(value="collateralBalanceStatus")
        public CollateralStatusEnum getCollateralBalanceStatus() {
            return this.collateralBalanceStatus;
        }

        @Override
        @RosettaAttribute(value="haircutIndicator")
        @RuneAttribute(value="haircutIndicator")
        public HaircutIndicatorEnum getHaircutIndicator() {
            return this.haircutIndicator;
        }

        @Override
        @RosettaAttribute(value="amountBaseCurrency", isRequired=true)
        @RuneAttribute(value="amountBaseCurrency", isRequired=true)
        public Money getAmountBaseCurrency() {
            return this.amountBaseCurrency;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public PartyReferencePayerReceiver getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public CollateralBalance build() {
            return this;
        }

        @Override
        public CollateralBalanceBuilder toBuilder() {
            CollateralBalanceBuilder builder = CollateralBalance.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralBalanceBuilder builder) {
            Optional.ofNullable(this.getCollateralBalanceStatus()).ifPresent(builder::setCollateralBalanceStatus);
            Optional.ofNullable(this.getHaircutIndicator()).ifPresent(builder::setHaircutIndicator);
            Optional.ofNullable(this.getAmountBaseCurrency()).ifPresent(builder::setAmountBaseCurrency);
            Optional.ofNullable(this.getPayerReceiver()).ifPresent(builder::setPayerReceiver);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralBalance _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.collateralBalanceStatus, (Object)_that.getCollateralBalanceStatus())) {
                return false;
            }
            if (!Objects.equals((Object)this.haircutIndicator, (Object)_that.getHaircutIndicator())) {
                return false;
            }
            if (!Objects.equals(this.amountBaseCurrency, _that.getAmountBaseCurrency())) {
                return false;
            }
            return Objects.equals(this.payerReceiver, _that.getPayerReceiver());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralBalanceStatus != null ? ((Object)((Object)this.collateralBalanceStatus)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.haircutIndicator != null ? ((Object)((Object)this.haircutIndicator)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amountBaseCurrency != null ? this.amountBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralBalance {collateralBalanceStatus=" + (Object)((Object)this.collateralBalanceStatus) + ", haircutIndicator=" + (Object)((Object)this.haircutIndicator) + ", amountBaseCurrency=" + this.amountBaseCurrency + ", payerReceiver=" + this.payerReceiver + '}';
        }
    }
}

