/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.meta.ContractDetailsMeta;
import cdm.legaldocumentation.common.GoverningLawEnum;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.metafields.FieldWithMetaGoverningLawEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ContractDetails", builder=ContractDetailsBuilderImpl.class, version="5.32.0")
@RuneDataType(value="ContractDetails", model="cdm", builder=ContractDetailsBuilderImpl.class, version="5.32.0")
public interface ContractDetails
extends RosettaModelObject,
GlobalKey {
    public static final ContractDetailsMeta metaData = new ContractDetailsMeta();

    public List<? extends LegalAgreement> getDocumentation();

    public FieldWithMetaGoverningLawEnum getGoverningLaw();

    public MetaFields getMeta();

    public ContractDetails build();

    public ContractDetailsBuilder toBuilder();

    public static ContractDetailsBuilder builder() {
        return new ContractDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends ContractDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ContractDetails> getType() {
        return ContractDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("documentation"), processor, LegalAgreement.class, this.getDocumentation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("governingLaw"), processor, FieldWithMetaGoverningLawEnum.class, this.getGoverningLaw(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class ContractDetailsBuilderImpl
    implements ContractDetailsBuilder {
        protected List<LegalAgreement.LegalAgreementBuilder> documentation = new ArrayList<LegalAgreement.LegalAgreementBuilder>();
        protected FieldWithMetaGoverningLawEnum.FieldWithMetaGoverningLawEnumBuilder governingLaw;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="documentation")
        @RuneAttribute(value="documentation")
        public List<? extends LegalAgreement.LegalAgreementBuilder> getDocumentation() {
            return this.documentation;
        }

        @Override
        public LegalAgreement.LegalAgreementBuilder getOrCreateDocumentation(int index) {
            if (this.documentation == null) {
                this.documentation = new ArrayList<LegalAgreement.LegalAgreementBuilder>();
            }
            return (LegalAgreement.LegalAgreementBuilder)this.getIndex(this.documentation, index, () -> {
                LegalAgreement.LegalAgreementBuilder newDocumentation = LegalAgreement.builder();
                return newDocumentation;
            });
        }

        @Override
        @RosettaAttribute(value="governingLaw")
        @RuneAttribute(value="governingLaw")
        public FieldWithMetaGoverningLawEnum.FieldWithMetaGoverningLawEnumBuilder getGoverningLaw() {
            return this.governingLaw;
        }

        @Override
        public FieldWithMetaGoverningLawEnum.FieldWithMetaGoverningLawEnumBuilder getOrCreateGoverningLaw() {
            FieldWithMetaGoverningLawEnum.FieldWithMetaGoverningLawEnumBuilder result = this.governingLaw != null ? this.governingLaw : (this.governingLaw = FieldWithMetaGoverningLawEnum.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="documentation")
        @RuneAttribute(value="documentation")
        public ContractDetailsBuilder addDocumentation(LegalAgreement _documentation) {
            if (_documentation != null) {
                this.documentation.add(_documentation.toBuilder());
            }
            return this;
        }

        @Override
        public ContractDetailsBuilder addDocumentation(LegalAgreement _documentation, int idx) {
            this.getIndex(this.documentation, idx, () -> _documentation.toBuilder());
            return this;
        }

        @Override
        public ContractDetailsBuilder addDocumentation(List<? extends LegalAgreement> documentations) {
            if (documentations != null) {
                for (LegalAgreement legalAgreement : documentations) {
                    this.documentation.add(legalAgreement.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="documentation")
        public ContractDetailsBuilder setDocumentation(List<? extends LegalAgreement> documentations) {
            this.documentation = documentations == null ? new ArrayList<LegalAgreement.LegalAgreementBuilder>() : (List)documentations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="governingLaw")
        @RuneAttribute(value="governingLaw")
        public ContractDetailsBuilder setGoverningLaw(FieldWithMetaGoverningLawEnum _governingLaw) {
            this.governingLaw = _governingLaw == null ? null : _governingLaw.toBuilder();
            return this;
        }

        @Override
        public ContractDetailsBuilder setGoverningLawValue(GoverningLawEnum _governingLaw) {
            this.getOrCreateGoverningLaw().setValue(_governingLaw);
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public ContractDetailsBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public ContractDetails build() {
            return new ContractDetailsImpl(this);
        }

        @Override
        public ContractDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public ContractDetailsBuilder prune() {
            this.documentation = this.documentation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.governingLaw != null && !this.governingLaw.prune().hasData()) {
                this.governingLaw = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDocumentation() != null && this.getDocumentation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getGoverningLaw() != null;
        }

        public ContractDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ContractDetailsBuilder o = (ContractDetailsBuilder)other;
            merger.mergeRosetta(this.getDocumentation(), o.getDocumentation(), this::getOrCreateDocumentation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGoverningLaw(), (RosettaModelObjectBuilder)o.getGoverningLaw(), this::setGoverningLaw);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ContractDetails _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.documentation, _that.getDocumentation())) {
                return false;
            }
            if (!Objects.equals(this.governingLaw, _that.getGoverningLaw())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.documentation != null ? this.documentation.hashCode() : 0);
            _result = 31 * _result + (this.governingLaw != null ? this.governingLaw.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ContractDetailsBuilder {documentation=" + this.documentation + ", governingLaw=" + this.governingLaw + ", meta=" + this.meta + '}';
        }
    }

    public static interface ContractDetailsBuilder
    extends ContractDetails,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public LegalAgreement.LegalAgreementBuilder getOrCreateDocumentation(int var1);

        public List<? extends LegalAgreement.LegalAgreementBuilder> getDocumentation();

        public FieldWithMetaGoverningLawEnum.FieldWithMetaGoverningLawEnumBuilder getOrCreateGoverningLaw();

        @Override
        public FieldWithMetaGoverningLawEnum.FieldWithMetaGoverningLawEnumBuilder getGoverningLaw();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public ContractDetailsBuilder addDocumentation(LegalAgreement var1);

        public ContractDetailsBuilder addDocumentation(LegalAgreement var1, int var2);

        public ContractDetailsBuilder addDocumentation(List<? extends LegalAgreement> var1);

        public ContractDetailsBuilder setDocumentation(List<? extends LegalAgreement> var1);

        public ContractDetailsBuilder setGoverningLaw(FieldWithMetaGoverningLawEnum var1);

        public ContractDetailsBuilder setGoverningLawValue(GoverningLawEnum var1);

        public ContractDetailsBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("documentation"), processor, LegalAgreement.LegalAgreementBuilder.class, this.getDocumentation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("governingLaw"), processor, FieldWithMetaGoverningLawEnum.FieldWithMetaGoverningLawEnumBuilder.class, this.getGoverningLaw(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public ContractDetailsBuilder prune();
    }

    public static class ContractDetailsImpl
    implements ContractDetails {
        private final List<? extends LegalAgreement> documentation;
        private final FieldWithMetaGoverningLawEnum governingLaw;
        private final MetaFields meta;

        protected ContractDetailsImpl(ContractDetailsBuilder builder) {
            this.documentation = Optional.ofNullable(builder.getDocumentation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.governingLaw = Optional.ofNullable(builder.getGoverningLaw()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="documentation")
        @RuneAttribute(value="documentation")
        public List<? extends LegalAgreement> getDocumentation() {
            return this.documentation;
        }

        @Override
        @RosettaAttribute(value="governingLaw")
        @RuneAttribute(value="governingLaw")
        public FieldWithMetaGoverningLawEnum getGoverningLaw() {
            return this.governingLaw;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public ContractDetails build() {
            return this;
        }

        @Override
        public ContractDetailsBuilder toBuilder() {
            ContractDetailsBuilder builder = ContractDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ContractDetailsBuilder builder) {
            Optional.ofNullable(this.getDocumentation()).ifPresent(builder::setDocumentation);
            Optional.ofNullable(this.getGoverningLaw()).ifPresent(builder::setGoverningLaw);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ContractDetails _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.documentation, _that.getDocumentation())) {
                return false;
            }
            if (!Objects.equals(this.governingLaw, _that.getGoverningLaw())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.documentation != null ? this.documentation.hashCode() : 0);
            _result = 31 * _result + (this.governingLaw != null ? this.governingLaw.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ContractDetails {documentation=" + this.documentation + ", governingLaw=" + this.governingLaw + ", meta=" + this.meta + '}';
        }
    }
}

