/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.datetime.TimeZone;
import cdm.base.datetime.metafields.FieldWithMetaTimeZone;
import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.AncillaryParty;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.ExecutionDetails;
import cdm.event.common.TradeIdentifier;
import cdm.event.common.meta.ExecutionInstructionMeta;
import cdm.product.collateral.Collateral;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.Product;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExecutionInstruction", builder=ExecutionInstructionBuilderImpl.class, version="5.32.0")
@RuneDataType(value="ExecutionInstruction", model="cdm", builder=ExecutionInstructionBuilderImpl.class, version="5.32.0")
public interface ExecutionInstruction
extends RosettaModelObject {
    public static final ExecutionInstructionMeta metaData = new ExecutionInstructionMeta();

    public Product getProduct();

    public List<? extends PriceQuantity> getPriceQuantity();

    public List<? extends Counterparty> getCounterparty();

    public List<? extends AncillaryParty> getAncillaryParty();

    public List<? extends Party> getParties();

    public List<? extends PartyRole> getPartyRoles();

    public ExecutionDetails getExecutionDetails();

    public FieldWithMetaDate getTradeDate();

    public FieldWithMetaTimeZone getTradeTime();

    public List<? extends TradeIdentifier> getTradeIdentifier();

    public Collateral getCollateral();

    public Identifier getLotIdentifier();

    public ExecutionInstruction build();

    public ExecutionInstructionBuilder toBuilder();

    public static ExecutionInstructionBuilder builder() {
        return new ExecutionInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends ExecutionInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExecutionInstruction> getType() {
        return ExecutionInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.class, this.getCounterparty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.class, this.getAncillaryParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("parties"), processor, Party.class, this.getParties(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRoles"), processor, PartyRole.class, this.getPartyRoles(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionDetails"), processor, ExecutionDetails.class, this.getExecutionDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeDate"), processor, FieldWithMetaDate.class, this.getTradeDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        this.processRosetta(path.newSubPath("tradeTime"), processor, FieldWithMetaTimeZone.class, this.getTradeTime(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, Collateral.class, this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lotIdentifier"), processor, Identifier.class, this.getLotIdentifier(), new AttributeMeta[0]);
    }

    public static class ExecutionInstructionBuilderImpl
    implements ExecutionInstructionBuilder {
        protected Product.ProductBuilder product;
        protected List<PriceQuantity.PriceQuantityBuilder> priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
        protected List<Counterparty.CounterpartyBuilder> counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();
        protected List<AncillaryParty.AncillaryPartyBuilder> ancillaryParty = new ArrayList<AncillaryParty.AncillaryPartyBuilder>();
        protected List<Party.PartyBuilder> parties = new ArrayList<Party.PartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRoles = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected ExecutionDetails.ExecutionDetailsBuilder executionDetails;
        protected FieldWithMetaDate.FieldWithMetaDateBuilder tradeDate;
        protected FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder tradeTime;
        protected List<TradeIdentifier.TradeIdentifierBuilder> tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
        protected Collateral.CollateralBuilder collateral;
        protected Identifier.IdentifierBuilder lotIdentifier;

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public Product.ProductBuilder getProduct() {
            return this.product;
        }

        @Override
        public Product.ProductBuilder getOrCreateProduct() {
            Product.ProductBuilder result = this.product != null ? this.product : (this.product = Product.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int index) {
            if (this.priceQuantity == null) {
                this.priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            }
            return (PriceQuantity.PriceQuantityBuilder)this.getIndex(this.priceQuantity, index, () -> {
                PriceQuantity.PriceQuantityBuilder newPriceQuantity = PriceQuantity.builder();
                return newPriceQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty() {
            return this.counterparty;
        }

        @Override
        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int index) {
            if (this.counterparty == null) {
                this.counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();
            }
            return (Counterparty.CounterpartyBuilder)this.getIndex(this.counterparty, index, () -> {
                Counterparty.CounterpartyBuilder newCounterparty = Counterparty.builder();
                return newCounterparty;
            });
        }

        @Override
        @RosettaAttribute(value="ancillaryParty")
        @RuneAttribute(value="ancillaryParty")
        public List<? extends AncillaryParty.AncillaryPartyBuilder> getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty(int index) {
            if (this.ancillaryParty == null) {
                this.ancillaryParty = new ArrayList<AncillaryParty.AncillaryPartyBuilder>();
            }
            return (AncillaryParty.AncillaryPartyBuilder)this.getIndex(this.ancillaryParty, index, () -> {
                AncillaryParty.AncillaryPartyBuilder newAncillaryParty = AncillaryParty.builder();
                return newAncillaryParty;
            });
        }

        @Override
        @RosettaAttribute(value="parties", isRequired=true)
        @RuneAttribute(value="parties", isRequired=true)
        public List<? extends Party.PartyBuilder> getParties() {
            return this.parties;
        }

        @Override
        public Party.PartyBuilder getOrCreateParties(int index) {
            if (this.parties == null) {
                this.parties = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.parties, index, () -> {
                Party.PartyBuilder newParties = Party.builder();
                return newParties;
            });
        }

        @Override
        @RosettaAttribute(value="partyRoles")
        @RuneAttribute(value="partyRoles")
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRoles() {
            return this.partyRoles;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRoles(int index) {
            if (this.partyRoles == null) {
                this.partyRoles = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRoles, index, () -> {
                PartyRole.PartyRoleBuilder newPartyRoles = PartyRole.builder();
                return newPartyRoles;
            });
        }

        @Override
        @RosettaAttribute(value="executionDetails", isRequired=true)
        @RuneAttribute(value="executionDetails", isRequired=true)
        public ExecutionDetails.ExecutionDetailsBuilder getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getOrCreateExecutionDetails() {
            ExecutionDetails.ExecutionDetailsBuilder result = this.executionDetails != null ? this.executionDetails : (this.executionDetails = ExecutionDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeDate", isRequired=true)
        @RuneAttribute(value="tradeDate", isRequired=true)
        public FieldWithMetaDate.FieldWithMetaDateBuilder getTradeDate() {
            return this.tradeDate;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateTradeDate() {
            FieldWithMetaDate.FieldWithMetaDateBuilder result = this.tradeDate != null ? this.tradeDate : (this.tradeDate = FieldWithMetaDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeTime")
        @RuneAttribute(value="tradeTime")
        public FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder getTradeTime() {
            return this.tradeTime;
        }

        @Override
        public FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder getOrCreateTradeTime() {
            FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder result = this.tradeTime != null ? this.tradeTime : (this.tradeTime = FieldWithMetaTimeZone.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newTradeIdentifier = TradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public Collateral.CollateralBuilder getCollateral() {
            return this.collateral;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateCollateral() {
            Collateral.CollateralBuilder result = this.collateral != null ? this.collateral : (this.collateral = Collateral.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lotIdentifier")
        @RuneAttribute(value="lotIdentifier")
        public Identifier.IdentifierBuilder getLotIdentifier() {
            return this.lotIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateLotIdentifier() {
            Identifier.IdentifierBuilder result = this.lotIdentifier != null ? this.lotIdentifier : (this.lotIdentifier = Identifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public ExecutionInstructionBuilder setProduct(Product _product) {
            this.product = _product == null ? null : _product.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public ExecutionInstructionBuilder addPriceQuantity(PriceQuantity _priceQuantity) {
            if (_priceQuantity != null) {
                this.priceQuantity.add(_priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPriceQuantity(PriceQuantity _priceQuantity, int idx) {
            this.getIndex(this.priceQuantity, idx, () -> _priceQuantity.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceQuantity")
        public ExecutionInstructionBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList<PriceQuantity.PriceQuantityBuilder>() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public ExecutionInstructionBuilder addCounterparty(Counterparty _counterparty) {
            if (_counterparty != null) {
                this.counterparty.add(_counterparty.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addCounterparty(Counterparty _counterparty, int idx) {
            this.getIndex(this.counterparty, idx, () -> _counterparty.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addCounterparty(List<? extends Counterparty> counterpartys) {
            if (counterpartys != null) {
                for (Counterparty counterparty : counterpartys) {
                    this.counterparty.add(counterparty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="counterparty")
        public ExecutionInstructionBuilder setCounterparty(List<? extends Counterparty> counterpartys) {
            this.counterparty = counterpartys == null ? new ArrayList<Counterparty.CounterpartyBuilder>() : (List)counterpartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="ancillaryParty")
        @RuneAttribute(value="ancillaryParty")
        public ExecutionInstructionBuilder addAncillaryParty(AncillaryParty _ancillaryParty) {
            if (_ancillaryParty != null) {
                this.ancillaryParty.add(_ancillaryParty.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addAncillaryParty(AncillaryParty _ancillaryParty, int idx) {
            this.getIndex(this.ancillaryParty, idx, () -> _ancillaryParty.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addAncillaryParty(List<? extends AncillaryParty> ancillaryPartys) {
            if (ancillaryPartys != null) {
                for (AncillaryParty ancillaryParty : ancillaryPartys) {
                    this.ancillaryParty.add(ancillaryParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="ancillaryParty")
        public ExecutionInstructionBuilder setAncillaryParty(List<? extends AncillaryParty> ancillaryPartys) {
            this.ancillaryParty = ancillaryPartys == null ? new ArrayList<AncillaryParty.AncillaryPartyBuilder>() : (List)ancillaryPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="parties", isRequired=true)
        @RuneAttribute(value="parties", isRequired=true)
        public ExecutionInstructionBuilder addParties(Party _parties) {
            if (_parties != null) {
                this.parties.add(_parties.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addParties(Party _parties, int idx) {
            this.getIndex(this.parties, idx, () -> _parties.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addParties(List<? extends Party> partiess) {
            if (partiess != null) {
                for (Party party : partiess) {
                    this.parties.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="parties")
        public ExecutionInstructionBuilder setParties(List<? extends Party> partiess) {
            this.parties = partiess == null ? new ArrayList<Party.PartyBuilder>() : (List)partiess.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRoles")
        @RuneAttribute(value="partyRoles")
        public ExecutionInstructionBuilder addPartyRoles(PartyRole _partyRoles) {
            if (_partyRoles != null) {
                this.partyRoles.add(_partyRoles.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPartyRoles(PartyRole _partyRoles, int idx) {
            this.getIndex(this.partyRoles, idx, () -> _partyRoles.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPartyRoles(List<? extends PartyRole> partyRoless) {
            if (partyRoless != null) {
                for (PartyRole partyRole : partyRoless) {
                    this.partyRoles.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyRoles")
        public ExecutionInstructionBuilder setPartyRoles(List<? extends PartyRole> partyRoless) {
            this.partyRoles = partyRoless == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoless.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="executionDetails", isRequired=true)
        @RuneAttribute(value="executionDetails", isRequired=true)
        public ExecutionInstructionBuilder setExecutionDetails(ExecutionDetails _executionDetails) {
            this.executionDetails = _executionDetails == null ? null : _executionDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeDate", isRequired=true)
        @RuneAttribute(value="tradeDate", isRequired=true)
        public ExecutionInstructionBuilder setTradeDate(FieldWithMetaDate _tradeDate) {
            this.tradeDate = _tradeDate == null ? null : _tradeDate.toBuilder();
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setTradeDateValue(Date _tradeDate) {
            this.getOrCreateTradeDate().setValue(_tradeDate);
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeTime")
        @RuneAttribute(value="tradeTime")
        public ExecutionInstructionBuilder setTradeTime(FieldWithMetaTimeZone _tradeTime) {
            this.tradeTime = _tradeTime == null ? null : _tradeTime.toBuilder();
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setTradeTimeValue(TimeZone _tradeTime) {
            this.getOrCreateTradeTime().setValue(_tradeTime);
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public ExecutionInstructionBuilder addTradeIdentifier(TradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addTradeIdentifier(TradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (TradeIdentifier tradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public ExecutionInstructionBuilder setTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public ExecutionInstructionBuilder setCollateral(Collateral _collateral) {
            this.collateral = _collateral == null ? null : _collateral.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lotIdentifier")
        @RuneAttribute(value="lotIdentifier")
        public ExecutionInstructionBuilder setLotIdentifier(Identifier _lotIdentifier) {
            this.lotIdentifier = _lotIdentifier == null ? null : _lotIdentifier.toBuilder();
            return this;
        }

        @Override
        public ExecutionInstruction build() {
            return new ExecutionInstructionImpl(this);
        }

        @Override
        public ExecutionInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public ExecutionInstructionBuilder prune() {
            if (this.product != null && !this.product.prune().hasData()) {
                this.product = null;
            }
            this.priceQuantity = this.priceQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.counterparty = this.counterparty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.ancillaryParty = this.ancillaryParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.parties = this.parties.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRoles = this.partyRoles.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.executionDetails != null && !this.executionDetails.prune().hasData()) {
                this.executionDetails = null;
            }
            if (this.tradeDate != null && !this.tradeDate.prune().hasData()) {
                this.tradeDate = null;
            }
            if (this.tradeTime != null && !this.tradeTime.prune().hasData()) {
                this.tradeTime = null;
            }
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.collateral != null && !this.collateral.prune().hasData()) {
                this.collateral = null;
            }
            if (this.lotIdentifier != null && !this.lotIdentifier.prune().hasData()) {
                this.lotIdentifier = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getProduct() != null && this.getProduct().hasData()) {
                return true;
            }
            if (this.getPriceQuantity() != null && this.getPriceQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCounterparty() != null && this.getCounterparty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAncillaryParty() != null && this.getAncillaryParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getParties() != null && this.getParties().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRoles() != null && this.getPartyRoles().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getExecutionDetails() != null && this.getExecutionDetails().hasData()) {
                return true;
            }
            if (this.getTradeDate() != null) {
                return true;
            }
            if (this.getTradeTime() != null && this.getTradeTime().hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateral() != null && this.getCollateral().hasData()) {
                return true;
            }
            return this.getLotIdentifier() != null && this.getLotIdentifier().hasData();
        }

        public ExecutionInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExecutionInstructionBuilder o = (ExecutionInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProduct(), (RosettaModelObjectBuilder)o.getProduct(), this::setProduct);
            merger.mergeRosetta(this.getPriceQuantity(), o.getPriceQuantity(), this::getOrCreatePriceQuantity);
            merger.mergeRosetta(this.getCounterparty(), o.getCounterparty(), this::getOrCreateCounterparty);
            merger.mergeRosetta(this.getAncillaryParty(), o.getAncillaryParty(), this::getOrCreateAncillaryParty);
            merger.mergeRosetta(this.getParties(), o.getParties(), this::getOrCreateParties);
            merger.mergeRosetta(this.getPartyRoles(), o.getPartyRoles(), this::getOrCreatePartyRoles);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionDetails(), (RosettaModelObjectBuilder)o.getExecutionDetails(), this::setExecutionDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeDate(), (RosettaModelObjectBuilder)o.getTradeDate(), this::setTradeDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeTime(), (RosettaModelObjectBuilder)o.getTradeTime(), this::setTradeTime);
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateral(), (RosettaModelObjectBuilder)o.getCollateral(), this::setCollateral);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLotIdentifier(), (RosettaModelObjectBuilder)o.getLotIdentifier(), this::setLotIdentifier);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExecutionInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.parties, _that.getParties())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRoles, _that.getPartyRoles())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            if (!Objects.equals(this.tradeTime, _that.getTradeTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            return Objects.equals(this.lotIdentifier, _that.getLotIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.parties != null ? this.parties.hashCode() : 0);
            _result = 31 * _result + (this.partyRoles != null ? this.partyRoles.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeTime != null ? this.tradeTime.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.lotIdentifier != null ? this.lotIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExecutionInstructionBuilder {product=" + this.product + ", priceQuantity=" + this.priceQuantity + ", counterparty=" + this.counterparty + ", ancillaryParty=" + this.ancillaryParty + ", parties=" + this.parties + ", partyRoles=" + this.partyRoles + ", executionDetails=" + this.executionDetails + ", tradeDate=" + this.tradeDate + ", tradeTime=" + this.tradeTime + ", tradeIdentifier=" + this.tradeIdentifier + ", collateral=" + this.collateral + ", lotIdentifier=" + this.lotIdentifier + '}';
        }
    }

    public static interface ExecutionInstructionBuilder
    extends ExecutionInstruction,
    RosettaModelObjectBuilder {
        public Product.ProductBuilder getOrCreateProduct();

        @Override
        public Product.ProductBuilder getProduct();

        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int var1);

        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity();

        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int var1);

        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty();

        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty(int var1);

        public List<? extends AncillaryParty.AncillaryPartyBuilder> getAncillaryParty();

        public Party.PartyBuilder getOrCreateParties(int var1);

        public List<? extends Party.PartyBuilder> getParties();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRoles(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRoles();

        public ExecutionDetails.ExecutionDetailsBuilder getOrCreateExecutionDetails();

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getExecutionDetails();

        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateTradeDate();

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getTradeDate();

        public FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder getOrCreateTradeTime();

        @Override
        public FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder getTradeTime();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier();

        public Collateral.CollateralBuilder getOrCreateCollateral();

        @Override
        public Collateral.CollateralBuilder getCollateral();

        public Identifier.IdentifierBuilder getOrCreateLotIdentifier();

        @Override
        public Identifier.IdentifierBuilder getLotIdentifier();

        public ExecutionInstructionBuilder setProduct(Product var1);

        public ExecutionInstructionBuilder addPriceQuantity(PriceQuantity var1);

        public ExecutionInstructionBuilder addPriceQuantity(PriceQuantity var1, int var2);

        public ExecutionInstructionBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        public ExecutionInstructionBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        public ExecutionInstructionBuilder addCounterparty(Counterparty var1);

        public ExecutionInstructionBuilder addCounterparty(Counterparty var1, int var2);

        public ExecutionInstructionBuilder addCounterparty(List<? extends Counterparty> var1);

        public ExecutionInstructionBuilder setCounterparty(List<? extends Counterparty> var1);

        public ExecutionInstructionBuilder addAncillaryParty(AncillaryParty var1);

        public ExecutionInstructionBuilder addAncillaryParty(AncillaryParty var1, int var2);

        public ExecutionInstructionBuilder addAncillaryParty(List<? extends AncillaryParty> var1);

        public ExecutionInstructionBuilder setAncillaryParty(List<? extends AncillaryParty> var1);

        public ExecutionInstructionBuilder addParties(Party var1);

        public ExecutionInstructionBuilder addParties(Party var1, int var2);

        public ExecutionInstructionBuilder addParties(List<? extends Party> var1);

        public ExecutionInstructionBuilder setParties(List<? extends Party> var1);

        public ExecutionInstructionBuilder addPartyRoles(PartyRole var1);

        public ExecutionInstructionBuilder addPartyRoles(PartyRole var1, int var2);

        public ExecutionInstructionBuilder addPartyRoles(List<? extends PartyRole> var1);

        public ExecutionInstructionBuilder setPartyRoles(List<? extends PartyRole> var1);

        public ExecutionInstructionBuilder setExecutionDetails(ExecutionDetails var1);

        public ExecutionInstructionBuilder setTradeDate(FieldWithMetaDate var1);

        public ExecutionInstructionBuilder setTradeDateValue(Date var1);

        public ExecutionInstructionBuilder setTradeTime(FieldWithMetaTimeZone var1);

        public ExecutionInstructionBuilder setTradeTimeValue(TimeZone var1);

        public ExecutionInstructionBuilder addTradeIdentifier(TradeIdentifier var1);

        public ExecutionInstructionBuilder addTradeIdentifier(TradeIdentifier var1, int var2);

        public ExecutionInstructionBuilder addTradeIdentifier(List<? extends TradeIdentifier> var1);

        public ExecutionInstructionBuilder setTradeIdentifier(List<? extends TradeIdentifier> var1);

        public ExecutionInstructionBuilder setCollateral(Collateral var1);

        public ExecutionInstructionBuilder setLotIdentifier(Identifier var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.CounterpartyBuilder.class, this.getCounterparty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.AncillaryPartyBuilder.class, this.getAncillaryParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("parties"), processor, Party.PartyBuilder.class, this.getParties(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRoles"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRoles(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionDetails"), processor, ExecutionDetails.ExecutionDetailsBuilder.class, this.getExecutionDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeDate"), processor, FieldWithMetaDate.FieldWithMetaDateBuilder.class, this.getTradeDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
            this.processRosetta(path.newSubPath("tradeTime"), processor, FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder.class, this.getTradeTime(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, Collateral.CollateralBuilder.class, this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lotIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getLotIdentifier(), new AttributeMeta[0]);
        }

        public ExecutionInstructionBuilder prune();
    }

    public static class ExecutionInstructionImpl
    implements ExecutionInstruction {
        private final Product product;
        private final List<? extends PriceQuantity> priceQuantity;
        private final List<? extends Counterparty> counterparty;
        private final List<? extends AncillaryParty> ancillaryParty;
        private final List<? extends Party> parties;
        private final List<? extends PartyRole> partyRoles;
        private final ExecutionDetails executionDetails;
        private final FieldWithMetaDate tradeDate;
        private final FieldWithMetaTimeZone tradeTime;
        private final List<? extends TradeIdentifier> tradeIdentifier;
        private final Collateral collateral;
        private final Identifier lotIdentifier;

        protected ExecutionInstructionImpl(ExecutionInstructionBuilder builder) {
            this.product = Optional.ofNullable(builder.getProduct()).map(f -> f.build()).orElse(null);
            this.priceQuantity = Optional.ofNullable(builder.getPriceQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.counterparty = Optional.ofNullable(builder.getCounterparty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.ancillaryParty = Optional.ofNullable(builder.getAncillaryParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.parties = Optional.ofNullable(builder.getParties()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRoles = Optional.ofNullable(builder.getPartyRoles()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.executionDetails = Optional.ofNullable(builder.getExecutionDetails()).map(f -> f.build()).orElse(null);
            this.tradeDate = Optional.ofNullable(builder.getTradeDate()).map(f -> f.build()).orElse(null);
            this.tradeTime = Optional.ofNullable(builder.getTradeTime()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateral = Optional.ofNullable(builder.getCollateral()).map(f -> f.build()).orElse(null);
            this.lotIdentifier = Optional.ofNullable(builder.getLotIdentifier()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public Product getProduct() {
            return this.product;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public List<? extends Counterparty> getCounterparty() {
            return this.counterparty;
        }

        @Override
        @RosettaAttribute(value="ancillaryParty")
        @RuneAttribute(value="ancillaryParty")
        public List<? extends AncillaryParty> getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        @RosettaAttribute(value="parties", isRequired=true)
        @RuneAttribute(value="parties", isRequired=true)
        public List<? extends Party> getParties() {
            return this.parties;
        }

        @Override
        @RosettaAttribute(value="partyRoles")
        @RuneAttribute(value="partyRoles")
        public List<? extends PartyRole> getPartyRoles() {
            return this.partyRoles;
        }

        @Override
        @RosettaAttribute(value="executionDetails", isRequired=true)
        @RuneAttribute(value="executionDetails", isRequired=true)
        public ExecutionDetails getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        @RosettaAttribute(value="tradeDate", isRequired=true)
        @RuneAttribute(value="tradeDate", isRequired=true)
        public FieldWithMetaDate getTradeDate() {
            return this.tradeDate;
        }

        @Override
        @RosettaAttribute(value="tradeTime")
        @RuneAttribute(value="tradeTime")
        public FieldWithMetaTimeZone getTradeTime() {
            return this.tradeTime;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends TradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public Collateral getCollateral() {
            return this.collateral;
        }

        @Override
        @RosettaAttribute(value="lotIdentifier")
        @RuneAttribute(value="lotIdentifier")
        public Identifier getLotIdentifier() {
            return this.lotIdentifier;
        }

        @Override
        public ExecutionInstruction build() {
            return this;
        }

        @Override
        public ExecutionInstructionBuilder toBuilder() {
            ExecutionInstructionBuilder builder = ExecutionInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExecutionInstructionBuilder builder) {
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getPriceQuantity()).ifPresent(builder::setPriceQuantity);
            Optional.ofNullable(this.getCounterparty()).ifPresent(builder::setCounterparty);
            Optional.ofNullable(this.getAncillaryParty()).ifPresent(builder::setAncillaryParty);
            Optional.ofNullable(this.getParties()).ifPresent(builder::setParties);
            Optional.ofNullable(this.getPartyRoles()).ifPresent(builder::setPartyRoles);
            Optional.ofNullable(this.getExecutionDetails()).ifPresent(builder::setExecutionDetails);
            Optional.ofNullable(this.getTradeDate()).ifPresent(builder::setTradeDate);
            Optional.ofNullable(this.getTradeTime()).ifPresent(builder::setTradeTime);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
            Optional.ofNullable(this.getLotIdentifier()).ifPresent(builder::setLotIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExecutionInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.parties, _that.getParties())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRoles, _that.getPartyRoles())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            if (!Objects.equals(this.tradeTime, _that.getTradeTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            return Objects.equals(this.lotIdentifier, _that.getLotIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.parties != null ? this.parties.hashCode() : 0);
            _result = 31 * _result + (this.partyRoles != null ? this.partyRoles.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeTime != null ? this.tradeTime.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.lotIdentifier != null ? this.lotIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExecutionInstruction {product=" + this.product + ", priceQuantity=" + this.priceQuantity + ", counterparty=" + this.counterparty + ", ancillaryParty=" + this.ancillaryParty + ", parties=" + this.parties + ", partyRoles=" + this.partyRoles + ", executionDetails=" + this.executionDetails + ", tradeDate=" + this.tradeDate + ", tradeTime=" + this.tradeTime + ", tradeIdentifier=" + this.tradeIdentifier + ", collateral=" + this.collateral + ", lotIdentifier=" + this.lotIdentifier + '}';
        }
    }
}

