/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.meta.ExposureMeta;
import cdm.event.position.PortfolioState;
import cdm.event.position.metafields.ReferenceWithMetaPortfolioState;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Exposure", builder=ExposureBuilderImpl.class, version="5.32.0")
@RuneDataType(value="Exposure", model="cdm", builder=ExposureBuilderImpl.class, version="5.32.0")
public interface Exposure
extends RosettaModelObject {
    public static final ExposureMeta metaData = new ExposureMeta();

    public ReferenceWithMetaPortfolioState getTradePortfolio();

    public Money getAggregateValue();

    public ZonedDateTime getCalculationDateTime();

    public ZonedDateTime getValuationDateTime();

    public Exposure build();

    public ExposureBuilder toBuilder();

    public static ExposureBuilder builder() {
        return new ExposureBuilderImpl();
    }

    default public RosettaMetaData<? extends Exposure> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Exposure> getType() {
        return Exposure.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradePortfolio"), processor, ReferenceWithMetaPortfolioState.class, this.getTradePortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("aggregateValue"), processor, Money.class, this.getAggregateValue(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationDateTime"), ZonedDateTime.class, (Object)this.getCalculationDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationDateTime"), ZonedDateTime.class, (Object)this.getValuationDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ExposureBuilderImpl
    implements ExposureBuilder {
        protected ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder tradePortfolio;
        protected Money.MoneyBuilder aggregateValue;
        protected ZonedDateTime calculationDateTime;
        protected ZonedDateTime valuationDateTime;

        @Override
        @RosettaAttribute(value="tradePortfolio", isRequired=true)
        @RuneAttribute(value="tradePortfolio", isRequired=true)
        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getTradePortfolio() {
            return this.tradePortfolio;
        }

        @Override
        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getOrCreateTradePortfolio() {
            ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder result = this.tradePortfolio != null ? this.tradePortfolio : (this.tradePortfolio = ReferenceWithMetaPortfolioState.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="aggregateValue", isRequired=true)
        @RuneAttribute(value="aggregateValue", isRequired=true)
        public Money.MoneyBuilder getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAggregateValue() {
            Money.MoneyBuilder result = this.aggregateValue != null ? this.aggregateValue : (this.aggregateValue = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationDateTime")
        @RuneAttribute(value="calculationDateTime")
        public ZonedDateTime getCalculationDateTime() {
            return this.calculationDateTime;
        }

        @Override
        @RosettaAttribute(value="valuationDateTime", isRequired=true)
        @RuneAttribute(value="valuationDateTime", isRequired=true)
        public ZonedDateTime getValuationDateTime() {
            return this.valuationDateTime;
        }

        @Override
        @RosettaAttribute(value="tradePortfolio", isRequired=true)
        @RuneAttribute(value="tradePortfolio", isRequired=true)
        public ExposureBuilder setTradePortfolio(ReferenceWithMetaPortfolioState _tradePortfolio) {
            this.tradePortfolio = _tradePortfolio == null ? null : _tradePortfolio.toBuilder();
            return this;
        }

        @Override
        public ExposureBuilder setTradePortfolioValue(PortfolioState _tradePortfolio) {
            this.getOrCreateTradePortfolio().setValue(_tradePortfolio);
            return this;
        }

        @Override
        @RosettaAttribute(value="aggregateValue", isRequired=true)
        @RuneAttribute(value="aggregateValue", isRequired=true)
        public ExposureBuilder setAggregateValue(Money _aggregateValue) {
            this.aggregateValue = _aggregateValue == null ? null : _aggregateValue.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationDateTime")
        @RuneAttribute(value="calculationDateTime")
        public ExposureBuilder setCalculationDateTime(ZonedDateTime _calculationDateTime) {
            this.calculationDateTime = _calculationDateTime == null ? null : _calculationDateTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDateTime", isRequired=true)
        @RuneAttribute(value="valuationDateTime", isRequired=true)
        public ExposureBuilder setValuationDateTime(ZonedDateTime _valuationDateTime) {
            this.valuationDateTime = _valuationDateTime == null ? null : _valuationDateTime;
            return this;
        }

        @Override
        public Exposure build() {
            return new ExposureImpl(this);
        }

        @Override
        public ExposureBuilder toBuilder() {
            return this;
        }

        @Override
        public ExposureBuilder prune() {
            if (this.tradePortfolio != null && !this.tradePortfolio.prune().hasData()) {
                this.tradePortfolio = null;
            }
            if (this.aggregateValue != null && !this.aggregateValue.prune().hasData()) {
                this.aggregateValue = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradePortfolio() != null && this.getTradePortfolio().hasData()) {
                return true;
            }
            if (this.getAggregateValue() != null && this.getAggregateValue().hasData()) {
                return true;
            }
            if (this.getCalculationDateTime() != null) {
                return true;
            }
            return this.getValuationDateTime() != null;
        }

        public ExposureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExposureBuilder o = (ExposureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradePortfolio(), (RosettaModelObjectBuilder)o.getTradePortfolio(), this::setTradePortfolio);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAggregateValue(), (RosettaModelObjectBuilder)o.getAggregateValue(), this::setAggregateValue);
            merger.mergeBasic((Object)this.getCalculationDateTime(), (Object)o.getCalculationDateTime(), this::setCalculationDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationDateTime(), (Object)o.getValuationDateTime(), this::setValuationDateTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Exposure _that = this.getType().cast(o);
            if (!Objects.equals(this.tradePortfolio, _that.getTradePortfolio())) {
                return false;
            }
            if (!Objects.equals(this.aggregateValue, _that.getAggregateValue())) {
                return false;
            }
            if (!Objects.equals(this.calculationDateTime, _that.getCalculationDateTime())) {
                return false;
            }
            return Objects.equals(this.valuationDateTime, _that.getValuationDateTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradePortfolio != null ? this.tradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.aggregateValue != null ? this.aggregateValue.hashCode() : 0);
            _result = 31 * _result + (this.calculationDateTime != null ? this.calculationDateTime.hashCode() : 0);
            _result = 31 * _result + (this.valuationDateTime != null ? this.valuationDateTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExposureBuilder {tradePortfolio=" + this.tradePortfolio + ", aggregateValue=" + this.aggregateValue + ", calculationDateTime=" + this.calculationDateTime + ", valuationDateTime=" + this.valuationDateTime + '}';
        }
    }

    public static interface ExposureBuilder
    extends Exposure,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getOrCreateTradePortfolio();

        @Override
        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getTradePortfolio();

        public Money.MoneyBuilder getOrCreateAggregateValue();

        @Override
        public Money.MoneyBuilder getAggregateValue();

        public ExposureBuilder setTradePortfolio(ReferenceWithMetaPortfolioState var1);

        public ExposureBuilder setTradePortfolioValue(PortfolioState var1);

        public ExposureBuilder setAggregateValue(Money var1);

        public ExposureBuilder setCalculationDateTime(ZonedDateTime var1);

        public ExposureBuilder setValuationDateTime(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradePortfolio"), processor, ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder.class, this.getTradePortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("aggregateValue"), processor, Money.MoneyBuilder.class, this.getAggregateValue(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationDateTime"), ZonedDateTime.class, (Object)this.getCalculationDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationDateTime"), ZonedDateTime.class, (Object)this.getValuationDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ExposureBuilder prune();
    }

    public static class ExposureImpl
    implements Exposure {
        private final ReferenceWithMetaPortfolioState tradePortfolio;
        private final Money aggregateValue;
        private final ZonedDateTime calculationDateTime;
        private final ZonedDateTime valuationDateTime;

        protected ExposureImpl(ExposureBuilder builder) {
            this.tradePortfolio = Optional.ofNullable(builder.getTradePortfolio()).map(f -> f.build()).orElse(null);
            this.aggregateValue = Optional.ofNullable(builder.getAggregateValue()).map(f -> f.build()).orElse(null);
            this.calculationDateTime = builder.getCalculationDateTime();
            this.valuationDateTime = builder.getValuationDateTime();
        }

        @Override
        @RosettaAttribute(value="tradePortfolio", isRequired=true)
        @RuneAttribute(value="tradePortfolio", isRequired=true)
        public ReferenceWithMetaPortfolioState getTradePortfolio() {
            return this.tradePortfolio;
        }

        @Override
        @RosettaAttribute(value="aggregateValue", isRequired=true)
        @RuneAttribute(value="aggregateValue", isRequired=true)
        public Money getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        @RosettaAttribute(value="calculationDateTime")
        @RuneAttribute(value="calculationDateTime")
        public ZonedDateTime getCalculationDateTime() {
            return this.calculationDateTime;
        }

        @Override
        @RosettaAttribute(value="valuationDateTime", isRequired=true)
        @RuneAttribute(value="valuationDateTime", isRequired=true)
        public ZonedDateTime getValuationDateTime() {
            return this.valuationDateTime;
        }

        @Override
        public Exposure build() {
            return this;
        }

        @Override
        public ExposureBuilder toBuilder() {
            ExposureBuilder builder = Exposure.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExposureBuilder builder) {
            Optional.ofNullable(this.getTradePortfolio()).ifPresent(builder::setTradePortfolio);
            Optional.ofNullable(this.getAggregateValue()).ifPresent(builder::setAggregateValue);
            Optional.ofNullable(this.getCalculationDateTime()).ifPresent(builder::setCalculationDateTime);
            Optional.ofNullable(this.getValuationDateTime()).ifPresent(builder::setValuationDateTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Exposure _that = this.getType().cast(o);
            if (!Objects.equals(this.tradePortfolio, _that.getTradePortfolio())) {
                return false;
            }
            if (!Objects.equals(this.aggregateValue, _that.getAggregateValue())) {
                return false;
            }
            if (!Objects.equals(this.calculationDateTime, _that.getCalculationDateTime())) {
                return false;
            }
            return Objects.equals(this.valuationDateTime, _that.getValuationDateTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradePortfolio != null ? this.tradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.aggregateValue != null ? this.aggregateValue.hashCode() : 0);
            _result = 31 * _result + (this.calculationDateTime != null ? this.calculationDateTime.hashCode() : 0);
            _result = 31 * _result + (this.valuationDateTime != null ? this.valuationDateTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Exposure {tradePortfolio=" + this.tradePortfolio + ", aggregateValue=" + this.aggregateValue + ", calculationDateTime=" + this.calculationDateTime + ", valuationDateTime=" + this.valuationDateTime + '}';
        }
    }
}

