/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.meta.ResetInstructionMeta;
import cdm.product.template.Payout;
import cdm.product.template.metafields.ReferenceWithMetaPayout;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ResetInstruction", builder=ResetInstructionBuilderImpl.class, version="5.32.0")
@RuneDataType(value="ResetInstruction", model="cdm", builder=ResetInstructionBuilderImpl.class, version="5.32.0")
public interface ResetInstruction
extends RosettaModelObject {
    public static final ResetInstructionMeta metaData = new ResetInstructionMeta();

    public ReferenceWithMetaPayout getPayout();

    public Date getRateRecordDate();

    public Date getResetDate();

    public ResetInstruction build();

    public ResetInstructionBuilder toBuilder();

    public static ResetInstructionBuilder builder() {
        return new ResetInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends ResetInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ResetInstruction> getType() {
        return ResetInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payout"), processor, ReferenceWithMetaPayout.class, this.getPayout(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rateRecordDate"), Date.class, (Object)this.getRateRecordDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ResetInstructionBuilderImpl
    implements ResetInstructionBuilder {
        protected ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder payout;
        protected Date rateRecordDate;
        protected Date resetDate;

        @Override
        @RosettaAttribute(value="payout", isRequired=true)
        @RuneAttribute(value="payout", isRequired=true)
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getPayout() {
            return this.payout;
        }

        @Override
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getOrCreatePayout() {
            ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder result = this.payout != null ? this.payout : (this.payout = ReferenceWithMetaPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rateRecordDate")
        @RuneAttribute(value="rateRecordDate")
        public Date getRateRecordDate() {
            return this.rateRecordDate;
        }

        @Override
        @RosettaAttribute(value="resetDate", isRequired=true)
        @RuneAttribute(value="resetDate", isRequired=true)
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        @RosettaAttribute(value="payout", isRequired=true)
        @RuneAttribute(value="payout", isRequired=true)
        public ResetInstructionBuilder setPayout(ReferenceWithMetaPayout _payout) {
            this.payout = _payout == null ? null : _payout.toBuilder();
            return this;
        }

        @Override
        public ResetInstructionBuilder setPayoutValue(Payout _payout) {
            this.getOrCreatePayout().setValue(_payout);
            return this;
        }

        @Override
        @RosettaAttribute(value="rateRecordDate")
        @RuneAttribute(value="rateRecordDate")
        public ResetInstructionBuilder setRateRecordDate(Date _rateRecordDate) {
            this.rateRecordDate = _rateRecordDate == null ? null : _rateRecordDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="resetDate", isRequired=true)
        @RuneAttribute(value="resetDate", isRequired=true)
        public ResetInstructionBuilder setResetDate(Date _resetDate) {
            this.resetDate = _resetDate == null ? null : _resetDate;
            return this;
        }

        @Override
        public ResetInstruction build() {
            return new ResetInstructionImpl(this);
        }

        @Override
        public ResetInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public ResetInstructionBuilder prune() {
            if (this.payout != null && !this.payout.prune().hasData()) {
                this.payout = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPayout() != null && this.getPayout().hasData()) {
                return true;
            }
            if (this.getRateRecordDate() != null) {
                return true;
            }
            return this.getResetDate() != null;
        }

        public ResetInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ResetInstructionBuilder o = (ResetInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayout(), (RosettaModelObjectBuilder)o.getPayout(), this::setPayout);
            merger.mergeBasic((Object)this.getRateRecordDate(), (Object)o.getRateRecordDate(), this::setRateRecordDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getResetDate(), (Object)o.getResetDate(), this::setResetDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ResetInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!Objects.equals(this.rateRecordDate, _that.getRateRecordDate())) {
                return false;
            }
            return Objects.equals(this.resetDate, _that.getResetDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.rateRecordDate != null ? this.rateRecordDate.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ResetInstructionBuilder {payout=" + this.payout + ", rateRecordDate=" + this.rateRecordDate + ", resetDate=" + this.resetDate + '}';
        }
    }

    public static interface ResetInstructionBuilder
    extends ResetInstruction,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getOrCreatePayout();

        @Override
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getPayout();

        public ResetInstructionBuilder setPayout(ReferenceWithMetaPayout var1);

        public ResetInstructionBuilder setPayoutValue(Payout var1);

        public ResetInstructionBuilder setRateRecordDate(Date var1);

        public ResetInstructionBuilder setResetDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payout"), processor, ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder.class, this.getPayout(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rateRecordDate"), Date.class, (Object)this.getRateRecordDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ResetInstructionBuilder prune();
    }

    public static class ResetInstructionImpl
    implements ResetInstruction {
        private final ReferenceWithMetaPayout payout;
        private final Date rateRecordDate;
        private final Date resetDate;

        protected ResetInstructionImpl(ResetInstructionBuilder builder) {
            this.payout = Optional.ofNullable(builder.getPayout()).map(f -> f.build()).orElse(null);
            this.rateRecordDate = builder.getRateRecordDate();
            this.resetDate = builder.getResetDate();
        }

        @Override
        @RosettaAttribute(value="payout", isRequired=true)
        @RuneAttribute(value="payout", isRequired=true)
        public ReferenceWithMetaPayout getPayout() {
            return this.payout;
        }

        @Override
        @RosettaAttribute(value="rateRecordDate")
        @RuneAttribute(value="rateRecordDate")
        public Date getRateRecordDate() {
            return this.rateRecordDate;
        }

        @Override
        @RosettaAttribute(value="resetDate", isRequired=true)
        @RuneAttribute(value="resetDate", isRequired=true)
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        public ResetInstruction build() {
            return this;
        }

        @Override
        public ResetInstructionBuilder toBuilder() {
            ResetInstructionBuilder builder = ResetInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ResetInstructionBuilder builder) {
            Optional.ofNullable(this.getPayout()).ifPresent(builder::setPayout);
            Optional.ofNullable(this.getRateRecordDate()).ifPresent(builder::setRateRecordDate);
            Optional.ofNullable(this.getResetDate()).ifPresent(builder::setResetDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ResetInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!Objects.equals(this.rateRecordDate, _that.getRateRecordDate())) {
                return false;
            }
            return Objects.equals(this.resetDate, _that.getResetDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.rateRecordDate != null ? this.rateRecordDate.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ResetInstruction {payout=" + this.payout + ", rateRecordDate=" + this.rateRecordDate + ", resetDate=" + this.resetDate + '}';
        }
    }
}

