/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.PriceTimingEnum;
import cdm.event.common.ValuationSourceEnum;
import cdm.event.common.ValuationTypeEnum;
import cdm.event.common.meta.ValuationMeta;
import cdm.observable.asset.Money;
import cdm.observable.asset.Price;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Valuation", builder=ValuationBuilderImpl.class, version="5.32.0")
@RuneDataType(value="Valuation", model="cdm", builder=ValuationBuilderImpl.class, version="5.32.0")
public interface Valuation
extends RosettaModelObject {
    public static final ValuationMeta metaData = new ValuationMeta();

    public Money getAmount();

    public ZonedDateTime getTimestamp();

    public ValuationTypeEnum getMethod();

    public ValuationSourceEnum getSource();

    public BigDecimal getDelta();

    public PriceTimingEnum getValuationTiming();

    public Price getPriceComponent();

    public Valuation build();

    public ValuationBuilder toBuilder();

    public static ValuationBuilder builder() {
        return new ValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends Valuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Valuation> getType() {
        return Valuation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, Money.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("timestamp"), ZonedDateTime.class, (Object)this.getTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("method"), ValuationTypeEnum.class, (Object)this.getMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("source"), ValuationSourceEnum.class, (Object)this.getSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTiming"), PriceTimingEnum.class, (Object)this.getValuationTiming(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceComponent"), processor, Price.class, this.getPriceComponent(), new AttributeMeta[0]);
    }

    public static class ValuationBuilderImpl
    implements ValuationBuilder {
        protected Money.MoneyBuilder amount;
        protected ZonedDateTime timestamp;
        protected ValuationTypeEnum method;
        protected ValuationSourceEnum source;
        protected BigDecimal delta;
        protected PriceTimingEnum valuationTiming;
        protected Price.PriceBuilder priceComponent;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public Money.MoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAmount() {
            Money.MoneyBuilder result = this.amount != null ? this.amount : (this.amount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="timestamp", isRequired=true)
        @RuneAttribute(value="timestamp", isRequired=true)
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        @RosettaAttribute(value="method")
        @RuneAttribute(value="method")
        public ValuationTypeEnum getMethod() {
            return this.method;
        }

        @Override
        @RosettaAttribute(value="source")
        @RuneAttribute(value="source")
        public ValuationSourceEnum getSource() {
            return this.source;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="valuationTiming")
        @RuneAttribute(value="valuationTiming")
        public PriceTimingEnum getValuationTiming() {
            return this.valuationTiming;
        }

        @Override
        @RosettaAttribute(value="priceComponent")
        @RuneAttribute(value="priceComponent")
        public Price.PriceBuilder getPriceComponent() {
            return this.priceComponent;
        }

        @Override
        public Price.PriceBuilder getOrCreatePriceComponent() {
            Price.PriceBuilder result = this.priceComponent != null ? this.priceComponent : (this.priceComponent = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public ValuationBuilder setAmount(Money _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="timestamp", isRequired=true)
        @RuneAttribute(value="timestamp", isRequired=true)
        public ValuationBuilder setTimestamp(ZonedDateTime _timestamp) {
            this.timestamp = _timestamp == null ? null : _timestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="method")
        @RuneAttribute(value="method")
        public ValuationBuilder setMethod(ValuationTypeEnum _method) {
            this.method = _method == null ? null : _method;
            return this;
        }

        @Override
        @RosettaAttribute(value="source")
        @RuneAttribute(value="source")
        public ValuationBuilder setSource(ValuationSourceEnum _source) {
            this.source = _source == null ? null : _source;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public ValuationBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTiming")
        @RuneAttribute(value="valuationTiming")
        public ValuationBuilder setValuationTiming(PriceTimingEnum _valuationTiming) {
            this.valuationTiming = _valuationTiming == null ? null : _valuationTiming;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceComponent")
        @RuneAttribute(value="priceComponent")
        public ValuationBuilder setPriceComponent(Price _priceComponent) {
            this.priceComponent = _priceComponent == null ? null : _priceComponent.toBuilder();
            return this;
        }

        @Override
        public Valuation build() {
            return new ValuationImpl(this);
        }

        @Override
        public ValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.priceComponent != null && !this.priceComponent.prune().hasData()) {
                this.priceComponent = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getTimestamp() != null) {
                return true;
            }
            if (this.getMethod() != null) {
                return true;
            }
            if (this.getSource() != null) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getValuationTiming() != null) {
                return true;
            }
            return this.getPriceComponent() != null && this.getPriceComponent().hasData();
        }

        public ValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ValuationBuilder o = (ValuationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceComponent(), (RosettaModelObjectBuilder)o.getPriceComponent(), this::setPriceComponent);
            merger.mergeBasic((Object)this.getTimestamp(), (Object)o.getTimestamp(), this::setTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMethod(), (Object)o.getMethod(), this::setMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSource(), (Object)o.getSource(), this::setSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTiming(), (Object)o.getValuationTiming(), this::setValuationTiming, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Valuation _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.timestamp, _that.getTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.method, (Object)_that.getMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.source, (Object)_that.getSource())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationTiming, (Object)_that.getValuationTiming())) {
                return false;
            }
            return Objects.equals(this.priceComponent, _that.getPriceComponent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            _result = 31 * _result + (this.method != null ? ((Object)((Object)this.method)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.source != null ? ((Object)((Object)this.source)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.valuationTiming != null ? ((Object)((Object)this.valuationTiming)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceComponent != null ? this.priceComponent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationBuilder {amount=" + this.amount + ", timestamp=" + this.timestamp + ", method=" + (Object)((Object)this.method) + ", source=" + (Object)((Object)this.source) + ", delta=" + this.delta + ", valuationTiming=" + (Object)((Object)this.valuationTiming) + ", priceComponent=" + this.priceComponent + '}';
        }
    }

    public static interface ValuationBuilder
    extends Valuation,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateAmount();

        @Override
        public Money.MoneyBuilder getAmount();

        public Price.PriceBuilder getOrCreatePriceComponent();

        @Override
        public Price.PriceBuilder getPriceComponent();

        public ValuationBuilder setAmount(Money var1);

        public ValuationBuilder setTimestamp(ZonedDateTime var1);

        public ValuationBuilder setMethod(ValuationTypeEnum var1);

        public ValuationBuilder setSource(ValuationSourceEnum var1);

        public ValuationBuilder setDelta(BigDecimal var1);

        public ValuationBuilder setValuationTiming(PriceTimingEnum var1);

        public ValuationBuilder setPriceComponent(Price var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, Money.MoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("timestamp"), ZonedDateTime.class, (Object)this.getTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("method"), ValuationTypeEnum.class, (Object)this.getMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("source"), ValuationSourceEnum.class, (Object)this.getSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTiming"), PriceTimingEnum.class, (Object)this.getValuationTiming(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceComponent"), processor, Price.PriceBuilder.class, this.getPriceComponent(), new AttributeMeta[0]);
        }

        public ValuationBuilder prune();
    }

    public static class ValuationImpl
    implements Valuation {
        private final Money amount;
        private final ZonedDateTime timestamp;
        private final ValuationTypeEnum method;
        private final ValuationSourceEnum source;
        private final BigDecimal delta;
        private final PriceTimingEnum valuationTiming;
        private final Price priceComponent;

        protected ValuationImpl(ValuationBuilder builder) {
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.timestamp = builder.getTimestamp();
            this.method = builder.getMethod();
            this.source = builder.getSource();
            this.delta = builder.getDelta();
            this.valuationTiming = builder.getValuationTiming();
            this.priceComponent = Optional.ofNullable(builder.getPriceComponent()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public Money getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="timestamp", isRequired=true)
        @RuneAttribute(value="timestamp", isRequired=true)
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        @RosettaAttribute(value="method")
        @RuneAttribute(value="method")
        public ValuationTypeEnum getMethod() {
            return this.method;
        }

        @Override
        @RosettaAttribute(value="source")
        @RuneAttribute(value="source")
        public ValuationSourceEnum getSource() {
            return this.source;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="valuationTiming")
        @RuneAttribute(value="valuationTiming")
        public PriceTimingEnum getValuationTiming() {
            return this.valuationTiming;
        }

        @Override
        @RosettaAttribute(value="priceComponent")
        @RuneAttribute(value="priceComponent")
        public Price getPriceComponent() {
            return this.priceComponent;
        }

        @Override
        public Valuation build() {
            return this;
        }

        @Override
        public ValuationBuilder toBuilder() {
            ValuationBuilder builder = Valuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getTimestamp()).ifPresent(builder::setTimestamp);
            Optional.ofNullable(this.getMethod()).ifPresent(builder::setMethod);
            Optional.ofNullable(this.getSource()).ifPresent(builder::setSource);
            Optional.ofNullable(this.getDelta()).ifPresent(builder::setDelta);
            Optional.ofNullable(this.getValuationTiming()).ifPresent(builder::setValuationTiming);
            Optional.ofNullable(this.getPriceComponent()).ifPresent(builder::setPriceComponent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Valuation _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.timestamp, _that.getTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.method, (Object)_that.getMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.source, (Object)_that.getSource())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationTiming, (Object)_that.getValuationTiming())) {
                return false;
            }
            return Objects.equals(this.priceComponent, _that.getPriceComponent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            _result = 31 * _result + (this.method != null ? ((Object)((Object)this.method)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.source != null ? ((Object)((Object)this.source)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.valuationTiming != null ? ((Object)((Object)this.valuationTiming)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceComponent != null ? this.priceComponent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Valuation {amount=" + this.amount + ", timestamp=" + this.timestamp + ", method=" + (Object)((Object)this.method) + ", source=" + (Object)((Object)this.source) + ", delta=" + this.delta + ", valuationTiming=" + (Object)((Object)this.valuationTiming) + ", priceComponent=" + this.priceComponent + '}';
        }
    }
}

