/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.ContractFormationInstruction;
import cdm.legaldocumentation.common.LegalAgreement;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_ContractFormationInstructionDefault.class)
public abstract class Create_ContractFormationInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public ContractFormationInstruction evaluate(List<? extends LegalAgreement> legalAgreement) {
        ContractFormationInstruction instruction;
        this.conditionValidator.validate(() -> {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of((List)legalAgreement)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of((List)legalAgreement).map("getAgreementDate", _legalAgreement -> _legalAgreement.getAgreementDate()));
            }
            return ComparisonResult.ofEmpty();
        }, "The full formation of a contract can only be completed with executed legal agreements if any.");
        ContractFormationInstruction.ContractFormationInstructionBuilder instructionBuilder = this.doEvaluate(legalAgreement);
        if (instructionBuilder == null) {
            instruction = null;
        } else {
            instruction = instructionBuilder.build();
            this.objectValidator.validate(ContractFormationInstruction.class, (RosettaModelObject)instruction);
        }
        return instruction;
    }

    protected abstract ContractFormationInstruction.ContractFormationInstructionBuilder doEvaluate(List<? extends LegalAgreement> var1);

    public static class Create_ContractFormationInstructionDefault
    extends Create_ContractFormationInstruction {
        @Override
        protected ContractFormationInstruction.ContractFormationInstructionBuilder doEvaluate(List<? extends LegalAgreement> legalAgreement) {
            if (legalAgreement == null) {
                legalAgreement = Collections.emptyList();
            }
            ContractFormationInstruction.ContractFormationInstructionBuilder instruction = ContractFormationInstruction.builder();
            return this.assignOutput(instruction, legalAgreement);
        }

        protected ContractFormationInstruction.ContractFormationInstructionBuilder assignOutput(ContractFormationInstruction.ContractFormationInstructionBuilder instruction, List<? extends LegalAgreement> legalAgreement) {
            instruction.addLegalAgreement(legalAgreement);
            return Optional.ofNullable(instruction).map(o -> o.prune()).orElse(null);
        }
    }
}

