/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_TerminationInstruction;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_PartialDeliveryPrimitiveInstructionDefault.class)
public abstract class Create_PartialDeliveryPrimitiveInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_TerminationInstruction create_TerminationInstruction;

    public PrimitiveInstruction evaluate(TradeState tradeState, List<? extends PriceQuantity> deliveredPriceQuantity) {
        PrimitiveInstruction instruction;
        this.conditionValidator.validate(() -> ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct())), "This function applies to contractual products only.");
        PrimitiveInstruction.PrimitiveInstructionBuilder instructionBuilder = this.doEvaluate(tradeState, deliveredPriceQuantity);
        if (instructionBuilder == null) {
            instruction = null;
        } else {
            instruction = instructionBuilder.build();
            this.objectValidator.validate(PrimitiveInstruction.class, (RosettaModelObject)instruction);
        }
        return instruction;
    }

    protected abstract PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState var1, List<? extends PriceQuantity> var2);

    public static class Create_PartialDeliveryPrimitiveInstructionDefault
    extends Create_PartialDeliveryPrimitiveInstruction {
        @Override
        protected PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState tradeState, List<? extends PriceQuantity> deliveredPriceQuantity) {
            if (deliveredPriceQuantity == null) {
                deliveredPriceQuantity = Collections.emptyList();
            }
            PrimitiveInstruction.PrimitiveInstructionBuilder instruction = PrimitiveInstruction.builder();
            return this.assignOutput(instruction, tradeState, deliveredPriceQuantity);
        }

        protected PrimitiveInstruction.PrimitiveInstructionBuilder assignOutput(PrimitiveInstruction.PrimitiveInstructionBuilder instruction, TradeState tradeState, List<? extends PriceQuantity> deliveredPriceQuantity) {
            instruction.getOrCreateSplit().setBreakdown(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.create_TerminationInstruction.evaluate(tradeState))}).getMulti());
            instruction.getOrCreateSplit().setBreakdown(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)PrimitiveInstruction.builder().setQuantityChange(QuantityChangeInstruction.builder().setChange(new ArrayList<PriceQuantity>(deliveredPriceQuantity)).setDirection(QuantityChangeDirectionEnum.REPLACE).setLotIdentifier(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getLotIdentifier", tradeLot -> tradeLot.getLotIdentifier()).getMulti()).build()).build())}).getMulti());
            return Optional.ofNullable(instruction).map(o -> o.prune()).orElse(null);
        }
    }
}

