/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.staticdata.party.AncillaryParty;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.ContractFormationInstruction;
import cdm.event.common.ExecutionInstruction;
import cdm.event.common.IndexTransitionInstruction;
import cdm.event.common.ObservationInstruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.ResetInstruction;
import cdm.event.common.StockSplitInstruction;
import cdm.event.common.TermsChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.TransferInstruction;
import cdm.event.common.ValuationInstruction;
import cdm.event.common.functions.Create_ContractFormation;
import cdm.event.common.functions.Create_Execution;
import cdm.event.common.functions.Create_IndexTransitionTermsChange;
import cdm.event.common.functions.Create_Observation;
import cdm.event.common.functions.Create_PartyChange;
import cdm.event.common.functions.Create_QuantityChange;
import cdm.event.common.functions.Create_Reset;
import cdm.event.common.functions.Create_StockSplit;
import cdm.event.common.functions.Create_TermsChange;
import cdm.event.common.functions.Create_Transfer;
import cdm.event.common.functions.Create_Valuation;
import cdm.event.position.PositionStatusEnum;
import cdm.legaldocumentation.common.ClosedState;
import cdm.legaldocumentation.common.ClosedStateEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_TradeStateDefault.class)
public abstract class Create_TradeState
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_ContractFormation create_ContractFormation;
    @Inject
    protected Create_Execution create_Execution;
    @Inject
    protected Create_IndexTransitionTermsChange create_IndexTransitionTermsChange;
    @Inject
    protected Create_Observation create_Observation;
    @Inject
    protected Create_PartyChange create_PartyChange;
    @Inject
    protected Create_QuantityChange create_QuantityChange;
    @Inject
    protected Create_Reset create_Reset;
    @Inject
    protected Create_StockSplit create_StockSplit;
    @Inject
    protected Create_TermsChange create_TermsChange;
    @Inject
    protected Create_Transfer create_Transfer;
    @Inject
    protected Create_Valuation create_Valuation;

    public TradeState evaluate(PrimitiveInstruction primitiveInstruction, TradeState before) {
        TradeState after;
        this.conditionValidator.validate(() -> ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getSplit", _primitiveInstruction -> _primitiveInstruction.getSplit())), "The primitive instruction cannot contain a split, as this function is designed to return a single trade state.");
        TradeState.TradeStateBuilder afterBuilder = this.doEvaluate(primitiveInstruction, before);
        if (afterBuilder == null) {
            after = null;
        } else {
            after = afterBuilder.build();
            this.objectValidator.validate(TradeState.class, (RosettaModelObject)after);
        }
        return after;
    }

    protected abstract TradeState.TradeStateBuilder doEvaluate(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> execution(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> quantityChange(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> termsChange(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> partyChange(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> contractFormation(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> transfer(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> reset(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> indexTransition(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> observation(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> valuation(PrimitiveInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> stockSplit(PrimitiveInstruction var1, TradeState var2);

    public static class Create_TradeStateDefault
    extends Create_TradeState {
        @Override
        protected TradeState.TradeStateBuilder doEvaluate(PrimitiveInstruction primitiveInstruction, TradeState before) {
            TradeState.TradeStateBuilder after = TradeState.builder();
            return this.assignOutput(after, primitiveInstruction, before);
        }

        protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder after, PrimitiveInstruction primitiveInstruction, TradeState before) {
            after = (TradeState.TradeStateBuilder)this.toBuilder((RosettaModelObject)this.stockSplit(primitiveInstruction, before).get(), () -> TradeState.builder());
            ClosedState ifThenElseResult = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)this.contractFormation(primitiveInstruction, before).map("getState", tradeState -> tradeState.getState()).map("getPositionState", state -> state.getPositionState()), (Mapper)MapperS.of((Object)((Object)PositionStatusEnum.CLOSED)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = ClosedState.builder().setState(ClosedStateEnum.TERMINATED).setActivityDate(null).build();
            }
            after.getOrCreateState().setClosedState(ifThenElseResult);
            return Optional.ofNullable(after).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends TradeState> execution(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getExecution", _primitiveInstruction -> _primitiveInstruction.getExecution())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)before);
            }
            return MapperS.of((Object)this.create_Execution.evaluate((ExecutionInstruction)MapperS.of((Object)primitiveInstruction).map("getExecution", _primitiveInstruction -> _primitiveInstruction.getExecution()).get()));
        }

        @Override
        protected MapperS<? extends TradeState> quantityChange(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getQuantityChange", _primitiveInstruction -> _primitiveInstruction.getQuantityChange())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.execution(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_QuantityChange.evaluate((QuantityChangeInstruction)MapperS.of((Object)primitiveInstruction).map("getQuantityChange", _primitiveInstruction -> _primitiveInstruction.getQuantityChange()).get(), (TradeState)this.execution(primitiveInstruction, before).get()));
        }

        @Override
        protected MapperS<? extends TradeState> termsChange(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getTermsChange", _primitiveInstruction -> _primitiveInstruction.getTermsChange())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.quantityChange(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_TermsChange.evaluate((TermsChangeInstruction)MapperS.of((Object)primitiveInstruction).map("getTermsChange", _primitiveInstruction -> _primitiveInstruction.getTermsChange()).get(), (TradeState)this.quantityChange(primitiveInstruction, before).get()));
        }

        @Override
        protected MapperS<? extends TradeState> partyChange(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getPartyChange", _primitiveInstruction -> _primitiveInstruction.getPartyChange())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.termsChange(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_PartyChange.evaluate((Counterparty)MapperS.of((Object)primitiveInstruction).map("getPartyChange", _primitiveInstruction -> _primitiveInstruction.getPartyChange()).map("getCounterparty", partyChangeInstruction -> partyChangeInstruction.getCounterparty()).get(), (AncillaryParty)MapperS.of((Object)primitiveInstruction).map("getPartyChange", _primitiveInstruction -> _primitiveInstruction.getPartyChange()).map("getAncillaryParty", partyChangeInstruction -> partyChangeInstruction.getAncillaryParty()).get(), (PartyRole)MapperS.of((Object)primitiveInstruction).map("getPartyChange", _primitiveInstruction -> _primitiveInstruction.getPartyChange()).map("getPartyRole", partyChangeInstruction -> partyChangeInstruction.getPartyRole()).get(), MapperS.of((Object)primitiveInstruction).map("getPartyChange", _primitiveInstruction -> _primitiveInstruction.getPartyChange()).mapC("getTradeId", partyChangeInstruction -> partyChangeInstruction.getTradeId()).getMulti(), (TradeState)this.termsChange(primitiveInstruction, before).get()));
        }

        @Override
        protected MapperS<? extends TradeState> contractFormation(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)primitiveInstruction)).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getContractFormation", _primitiveInstruction -> _primitiveInstruction.getContractFormation()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.partyChange(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_ContractFormation.evaluate((ContractFormationInstruction)MapperS.of((Object)primitiveInstruction).map("getContractFormation", _primitiveInstruction -> _primitiveInstruction.getContractFormation()).get(), (TradeState)this.partyChange(primitiveInstruction, before).get()));
        }

        @Override
        protected MapperS<? extends TradeState> transfer(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getTransfer", _primitiveInstruction -> _primitiveInstruction.getTransfer())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.contractFormation(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_Transfer.evaluate((TransferInstruction)MapperS.of((Object)primitiveInstruction).map("getTransfer", _primitiveInstruction -> _primitiveInstruction.getTransfer()).get(), (TradeState)this.contractFormation(primitiveInstruction, before).get()));
        }

        @Override
        protected MapperS<? extends TradeState> reset(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getReset", _primitiveInstruction -> _primitiveInstruction.getReset())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.transfer(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_Reset.evaluate((ResetInstruction)MapperS.of((Object)primitiveInstruction).map("getReset", _primitiveInstruction -> _primitiveInstruction.getReset()).get(), (TradeState)this.transfer(primitiveInstruction, before).get()));
        }

        @Override
        protected MapperS<? extends TradeState> indexTransition(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getIndexTransition", _primitiveInstruction -> _primitiveInstruction.getIndexTransition())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.reset(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_IndexTransitionTermsChange.evaluate((IndexTransitionInstruction)MapperS.of((Object)primitiveInstruction).map("getIndexTransition", _primitiveInstruction -> _primitiveInstruction.getIndexTransition()).get(), (TradeState)this.reset(primitiveInstruction, before).get()));
        }

        @Override
        protected MapperS<? extends TradeState> observation(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getObservation", _primitiveInstruction -> _primitiveInstruction.getObservation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.indexTransition(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_Observation.evaluate((ObservationInstruction)MapperS.of((Object)primitiveInstruction).map("getObservation", _primitiveInstruction -> _primitiveInstruction.getObservation()).get(), (TradeState)this.indexTransition(primitiveInstruction, before).get()));
        }

        @Override
        protected MapperS<? extends TradeState> valuation(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getValuation", _primitiveInstruction -> _primitiveInstruction.getValuation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.observation(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_Valuation.evaluate((ValuationInstruction)MapperS.of((Object)primitiveInstruction).map("getValuation", _primitiveInstruction -> _primitiveInstruction.getValuation()).get(), (TradeState)this.observation(primitiveInstruction, before).get()));
        }

        @Override
        protected MapperS<? extends TradeState> stockSplit(PrimitiveInstruction primitiveInstruction, TradeState before) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)primitiveInstruction).map("getStockSplit", _primitiveInstruction -> _primitiveInstruction.getStockSplit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.valuation(primitiveInstruction, before);
            }
            return MapperS.of((Object)this.create_StockSplit.evaluate((StockSplitInstruction)MapperS.of((Object)primitiveInstruction).map("getStockSplit", _primitiveInstruction -> _primitiveInstruction.getStockSplit()).get(), (TradeState)this.valuation(primitiveInstruction, before).get()));
        }
    }
}

