/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Instruction;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="InstructionNewTrade")
@ImplementedBy(value=Default.class)
public interface InstructionNewTrade
extends Validator<Instruction> {
    public static final String NAME = "InstructionNewTrade";
    public static final String DEFINITION = "(if primitiveInstruction -> execution exists then before is absent else True) and (if before is absent then primitiveInstruction -> execution exists else True)";

    public static class NoOp
    implements InstructionNewTrade {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Instruction instruction) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements InstructionNewTrade {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Instruction instruction) {
            ComparisonResult result = this.executeDataRule(instruction);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)InstructionNewTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionNewTrade.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)InstructionNewTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionNewTrade.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Instruction instruction) {
            try {
                ComparisonResult ifThenElseResult0 = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()).map("getExecution", primitiveInstruction -> primitiveInstruction.getExecution())).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)instruction).map("getBefore", _instruction -> _instruction.getBefore())) : ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)true));
                ComparisonResult ifThenElseResult1 = ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)instruction).map("getBefore", _instruction -> _instruction.getBefore())).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()).map("getExecution", primitiveInstruction -> primitiveInstruction.getExecution())) : ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)true));
                return ifThenElseResult0.andNullSafe(ifThenElseResult1);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

