/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.meta.RateObservationMeta;
import cdm.observable.asset.metafields.ReferenceWithMetaRateObservation;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RateObservation", builder=RateObservationBuilderImpl.class, version="5.32.0")
@RuneDataType(value="RateObservation", model="cdm", builder=RateObservationBuilderImpl.class, version="5.32.0")
public interface RateObservation
extends RosettaModelObject,
GlobalKey {
    public static final RateObservationMeta metaData = new RateObservationMeta();

    public Date getResetDate();

    public Date getAdjustedFixingDate();

    public BigDecimal getObservedRate();

    public BigDecimal getTreatedRate();

    public Integer getObservationWeight();

    public ReferenceWithMetaRateObservation getRateReference();

    public BigDecimal getForecastRate();

    public BigDecimal getTreatedForecastRate();

    public MetaFields getMeta();

    public RateObservation build();

    public RateObservationBuilder toBuilder();

    public static RateObservationBuilder builder() {
        return new RateObservationBuilderImpl();
    }

    default public RosettaMetaData<? extends RateObservation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RateObservation> getType() {
        return RateObservation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedFixingDate"), Date.class, (Object)this.getAdjustedFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observedRate"), BigDecimal.class, (Object)this.getObservedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("treatedRate"), BigDecimal.class, (Object)this.getTreatedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observationWeight"), Integer.class, (Object)this.getObservationWeight(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateReference"), processor, ReferenceWithMetaRateObservation.class, this.getRateReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("forecastRate"), BigDecimal.class, (Object)this.getForecastRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("treatedForecastRate"), BigDecimal.class, (Object)this.getTreatedForecastRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class RateObservationBuilderImpl
    implements RateObservationBuilder {
        protected Date resetDate;
        protected Date adjustedFixingDate;
        protected BigDecimal observedRate;
        protected BigDecimal treatedRate;
        protected Integer observationWeight;
        protected ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder rateReference;
        protected BigDecimal forecastRate;
        protected BigDecimal treatedForecastRate;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="resetDate")
        @RuneAttribute(value="resetDate")
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        @RosettaAttribute(value="adjustedFixingDate")
        @RuneAttribute(value="adjustedFixingDate")
        public Date getAdjustedFixingDate() {
            return this.adjustedFixingDate;
        }

        @Override
        @RosettaAttribute(value="observedRate")
        @RuneAttribute(value="observedRate")
        public BigDecimal getObservedRate() {
            return this.observedRate;
        }

        @Override
        @RosettaAttribute(value="treatedRate")
        @RuneAttribute(value="treatedRate")
        public BigDecimal getTreatedRate() {
            return this.treatedRate;
        }

        @Override
        @RosettaAttribute(value="observationWeight")
        @RuneAttribute(value="observationWeight")
        public Integer getObservationWeight() {
            return this.observationWeight;
        }

        @Override
        @RosettaAttribute(value="rateReference")
        @RuneAttribute(value="rateReference")
        public ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder getRateReference() {
            return this.rateReference;
        }

        @Override
        public ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder getOrCreateRateReference() {
            ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder result = this.rateReference != null ? this.rateReference : (this.rateReference = ReferenceWithMetaRateObservation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="forecastRate")
        @RuneAttribute(value="forecastRate")
        public BigDecimal getForecastRate() {
            return this.forecastRate;
        }

        @Override
        @RosettaAttribute(value="treatedForecastRate")
        @RuneAttribute(value="treatedForecastRate")
        public BigDecimal getTreatedForecastRate() {
            return this.treatedForecastRate;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="resetDate")
        @RuneAttribute(value="resetDate")
        public RateObservationBuilder setResetDate(Date _resetDate) {
            this.resetDate = _resetDate == null ? null : _resetDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedFixingDate")
        @RuneAttribute(value="adjustedFixingDate")
        public RateObservationBuilder setAdjustedFixingDate(Date _adjustedFixingDate) {
            this.adjustedFixingDate = _adjustedFixingDate == null ? null : _adjustedFixingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="observedRate")
        @RuneAttribute(value="observedRate")
        public RateObservationBuilder setObservedRate(BigDecimal _observedRate) {
            this.observedRate = _observedRate == null ? null : _observedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="treatedRate")
        @RuneAttribute(value="treatedRate")
        public RateObservationBuilder setTreatedRate(BigDecimal _treatedRate) {
            this.treatedRate = _treatedRate == null ? null : _treatedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="observationWeight")
        @RuneAttribute(value="observationWeight")
        public RateObservationBuilder setObservationWeight(Integer _observationWeight) {
            this.observationWeight = _observationWeight == null ? null : _observationWeight;
            return this;
        }

        @Override
        @RosettaAttribute(value="rateReference")
        @RuneAttribute(value="rateReference")
        public RateObservationBuilder setRateReference(ReferenceWithMetaRateObservation _rateReference) {
            this.rateReference = _rateReference == null ? null : _rateReference.toBuilder();
            return this;
        }

        @Override
        public RateObservationBuilder setRateReferenceValue(RateObservation _rateReference) {
            this.getOrCreateRateReference().setValue(_rateReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="forecastRate")
        @RuneAttribute(value="forecastRate")
        public RateObservationBuilder setForecastRate(BigDecimal _forecastRate) {
            this.forecastRate = _forecastRate == null ? null : _forecastRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="treatedForecastRate")
        @RuneAttribute(value="treatedForecastRate")
        public RateObservationBuilder setTreatedForecastRate(BigDecimal _treatedForecastRate) {
            this.treatedForecastRate = _treatedForecastRate == null ? null : _treatedForecastRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public RateObservationBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public RateObservation build() {
            return new RateObservationImpl(this);
        }

        @Override
        public RateObservationBuilder toBuilder() {
            return this;
        }

        @Override
        public RateObservationBuilder prune() {
            if (this.rateReference != null && !this.rateReference.prune().hasData()) {
                this.rateReference = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getResetDate() != null) {
                return true;
            }
            if (this.getAdjustedFixingDate() != null) {
                return true;
            }
            if (this.getObservedRate() != null) {
                return true;
            }
            if (this.getTreatedRate() != null) {
                return true;
            }
            if (this.getObservationWeight() != null) {
                return true;
            }
            if (this.getRateReference() != null && this.getRateReference().hasData()) {
                return true;
            }
            if (this.getForecastRate() != null) {
                return true;
            }
            return this.getTreatedForecastRate() != null;
        }

        public RateObservationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RateObservationBuilder o = (RateObservationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateReference(), (RosettaModelObjectBuilder)o.getRateReference(), this::setRateReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getResetDate(), (Object)o.getResetDate(), this::setResetDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedFixingDate(), (Object)o.getAdjustedFixingDate(), this::setAdjustedFixingDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getObservedRate(), (Object)o.getObservedRate(), this::setObservedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTreatedRate(), (Object)o.getTreatedRate(), this::setTreatedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getObservationWeight(), (Object)o.getObservationWeight(), this::setObservationWeight, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getForecastRate(), (Object)o.getForecastRate(), this::setForecastRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTreatedForecastRate(), (Object)o.getTreatedForecastRate(), this::setTreatedForecastRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RateObservation _that = this.getType().cast(o);
            if (!Objects.equals(this.resetDate, _that.getResetDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedFixingDate, _that.getAdjustedFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.observedRate, _that.getObservedRate())) {
                return false;
            }
            if (!Objects.equals(this.treatedRate, _that.getTreatedRate())) {
                return false;
            }
            if (!Objects.equals(this.observationWeight, _that.getObservationWeight())) {
                return false;
            }
            if (!Objects.equals(this.rateReference, _that.getRateReference())) {
                return false;
            }
            if (!Objects.equals(this.forecastRate, _that.getForecastRate())) {
                return false;
            }
            if (!Objects.equals(this.treatedForecastRate, _that.getTreatedForecastRate())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedFixingDate != null ? this.adjustedFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.observedRate != null ? this.observedRate.hashCode() : 0);
            _result = 31 * _result + (this.treatedRate != null ? this.treatedRate.hashCode() : 0);
            _result = 31 * _result + (this.observationWeight != null ? this.observationWeight.hashCode() : 0);
            _result = 31 * _result + (this.rateReference != null ? this.rateReference.hashCode() : 0);
            _result = 31 * _result + (this.forecastRate != null ? this.forecastRate.hashCode() : 0);
            _result = 31 * _result + (this.treatedForecastRate != null ? this.treatedForecastRate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RateObservationBuilder {resetDate=" + this.resetDate + ", adjustedFixingDate=" + this.adjustedFixingDate + ", observedRate=" + this.observedRate + ", treatedRate=" + this.treatedRate + ", observationWeight=" + this.observationWeight + ", rateReference=" + this.rateReference + ", forecastRate=" + this.forecastRate + ", treatedForecastRate=" + this.treatedForecastRate + ", meta=" + this.meta + '}';
        }
    }

    public static interface RateObservationBuilder
    extends RateObservation,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder getOrCreateRateReference();

        @Override
        public ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder getRateReference();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public RateObservationBuilder setResetDate(Date var1);

        public RateObservationBuilder setAdjustedFixingDate(Date var1);

        public RateObservationBuilder setObservedRate(BigDecimal var1);

        public RateObservationBuilder setTreatedRate(BigDecimal var1);

        public RateObservationBuilder setObservationWeight(Integer var1);

        public RateObservationBuilder setRateReference(ReferenceWithMetaRateObservation var1);

        public RateObservationBuilder setRateReferenceValue(RateObservation var1);

        public RateObservationBuilder setForecastRate(BigDecimal var1);

        public RateObservationBuilder setTreatedForecastRate(BigDecimal var1);

        public RateObservationBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedFixingDate"), Date.class, (Object)this.getAdjustedFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observedRate"), BigDecimal.class, (Object)this.getObservedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("treatedRate"), BigDecimal.class, (Object)this.getTreatedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observationWeight"), Integer.class, (Object)this.getObservationWeight(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateReference"), processor, ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder.class, this.getRateReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("forecastRate"), BigDecimal.class, (Object)this.getForecastRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("treatedForecastRate"), BigDecimal.class, (Object)this.getTreatedForecastRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public RateObservationBuilder prune();
    }

    public static class RateObservationImpl
    implements RateObservation {
        private final Date resetDate;
        private final Date adjustedFixingDate;
        private final BigDecimal observedRate;
        private final BigDecimal treatedRate;
        private final Integer observationWeight;
        private final ReferenceWithMetaRateObservation rateReference;
        private final BigDecimal forecastRate;
        private final BigDecimal treatedForecastRate;
        private final MetaFields meta;

        protected RateObservationImpl(RateObservationBuilder builder) {
            this.resetDate = builder.getResetDate();
            this.adjustedFixingDate = builder.getAdjustedFixingDate();
            this.observedRate = builder.getObservedRate();
            this.treatedRate = builder.getTreatedRate();
            this.observationWeight = builder.getObservationWeight();
            this.rateReference = Optional.ofNullable(builder.getRateReference()).map(f -> f.build()).orElse(null);
            this.forecastRate = builder.getForecastRate();
            this.treatedForecastRate = builder.getTreatedForecastRate();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="resetDate")
        @RuneAttribute(value="resetDate")
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        @RosettaAttribute(value="adjustedFixingDate")
        @RuneAttribute(value="adjustedFixingDate")
        public Date getAdjustedFixingDate() {
            return this.adjustedFixingDate;
        }

        @Override
        @RosettaAttribute(value="observedRate")
        @RuneAttribute(value="observedRate")
        public BigDecimal getObservedRate() {
            return this.observedRate;
        }

        @Override
        @RosettaAttribute(value="treatedRate")
        @RuneAttribute(value="treatedRate")
        public BigDecimal getTreatedRate() {
            return this.treatedRate;
        }

        @Override
        @RosettaAttribute(value="observationWeight")
        @RuneAttribute(value="observationWeight")
        public Integer getObservationWeight() {
            return this.observationWeight;
        }

        @Override
        @RosettaAttribute(value="rateReference")
        @RuneAttribute(value="rateReference")
        public ReferenceWithMetaRateObservation getRateReference() {
            return this.rateReference;
        }

        @Override
        @RosettaAttribute(value="forecastRate")
        @RuneAttribute(value="forecastRate")
        public BigDecimal getForecastRate() {
            return this.forecastRate;
        }

        @Override
        @RosettaAttribute(value="treatedForecastRate")
        @RuneAttribute(value="treatedForecastRate")
        public BigDecimal getTreatedForecastRate() {
            return this.treatedForecastRate;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public RateObservation build() {
            return this;
        }

        @Override
        public RateObservationBuilder toBuilder() {
            RateObservationBuilder builder = RateObservation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RateObservationBuilder builder) {
            Optional.ofNullable(this.getResetDate()).ifPresent(builder::setResetDate);
            Optional.ofNullable(this.getAdjustedFixingDate()).ifPresent(builder::setAdjustedFixingDate);
            Optional.ofNullable(this.getObservedRate()).ifPresent(builder::setObservedRate);
            Optional.ofNullable(this.getTreatedRate()).ifPresent(builder::setTreatedRate);
            Optional.ofNullable(this.getObservationWeight()).ifPresent(builder::setObservationWeight);
            Optional.ofNullable(this.getRateReference()).ifPresent(builder::setRateReference);
            Optional.ofNullable(this.getForecastRate()).ifPresent(builder::setForecastRate);
            Optional.ofNullable(this.getTreatedForecastRate()).ifPresent(builder::setTreatedForecastRate);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RateObservation _that = this.getType().cast(o);
            if (!Objects.equals(this.resetDate, _that.getResetDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedFixingDate, _that.getAdjustedFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.observedRate, _that.getObservedRate())) {
                return false;
            }
            if (!Objects.equals(this.treatedRate, _that.getTreatedRate())) {
                return false;
            }
            if (!Objects.equals(this.observationWeight, _that.getObservationWeight())) {
                return false;
            }
            if (!Objects.equals(this.rateReference, _that.getRateReference())) {
                return false;
            }
            if (!Objects.equals(this.forecastRate, _that.getForecastRate())) {
                return false;
            }
            if (!Objects.equals(this.treatedForecastRate, _that.getTreatedForecastRate())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedFixingDate != null ? this.adjustedFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.observedRate != null ? this.observedRate.hashCode() : 0);
            _result = 31 * _result + (this.treatedRate != null ? this.treatedRate.hashCode() : 0);
            _result = 31 * _result + (this.observationWeight != null ? this.observationWeight.hashCode() : 0);
            _result = 31 * _result + (this.rateReference != null ? this.rateReference.hashCode() : 0);
            _result = 31 * _result + (this.forecastRate != null ? this.forecastRate.hashCode() : 0);
            _result = 31 * _result + (this.treatedForecastRate != null ? this.treatedForecastRate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RateObservation {resetDate=" + this.resetDate + ", adjustedFixingDate=" + this.adjustedFixingDate + ", observedRate=" + this.observedRate + ", treatedRate=" + this.treatedRate + ", observationWeight=" + this.observationWeight + ", rateReference=" + this.rateReference + ", forecastRate=" + this.forecastRate + ", treatedForecastRate=" + this.treatedForecastRate + ", meta=" + this.meta + '}';
        }
    }
}

