/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.BondEquityModel;
import cdm.observable.asset.meta.RelativePriceMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RelativePrice", builder=RelativePriceBuilderImpl.class, version="5.32.0")
@RuneDataType(value="RelativePrice", model="cdm", builder=RelativePriceBuilderImpl.class, version="5.32.0")
public interface RelativePrice
extends RosettaModelObject {
    public static final RelativePriceMeta metaData = new RelativePriceMeta();

    public BigDecimal getSpread();

    public List<? extends BondEquityModel> getBondEquityModel();

    public RelativePrice build();

    public RelativePriceBuilder toBuilder();

    public static RelativePriceBuilder builder() {
        return new RelativePriceBuilderImpl();
    }

    default public RosettaMetaData<? extends RelativePrice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RelativePrice> getType() {
        return RelativePrice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bondEquityModel"), processor, BondEquityModel.class, this.getBondEquityModel(), new AttributeMeta[0]);
    }

    public static class RelativePriceBuilderImpl
    implements RelativePriceBuilder {
        protected BigDecimal spread;
        protected List<BondEquityModel.BondEquityModelBuilder> bondEquityModel = new ArrayList<BondEquityModel.BondEquityModelBuilder>();

        @Override
        @RosettaAttribute(value="spread", isRequired=true)
        @RuneAttribute(value="spread", isRequired=true)
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="bondEquityModel", isRequired=true)
        @RuneAttribute(value="bondEquityModel", isRequired=true)
        public List<? extends BondEquityModel.BondEquityModelBuilder> getBondEquityModel() {
            return this.bondEquityModel;
        }

        @Override
        public BondEquityModel.BondEquityModelBuilder getOrCreateBondEquityModel(int index) {
            if (this.bondEquityModel == null) {
                this.bondEquityModel = new ArrayList<BondEquityModel.BondEquityModelBuilder>();
            }
            return (BondEquityModel.BondEquityModelBuilder)this.getIndex(this.bondEquityModel, index, () -> {
                BondEquityModel.BondEquityModelBuilder newBondEquityModel = BondEquityModel.builder();
                return newBondEquityModel;
            });
        }

        @Override
        @RosettaAttribute(value="spread", isRequired=true)
        @RuneAttribute(value="spread", isRequired=true)
        public RelativePriceBuilder setSpread(BigDecimal _spread) {
            this.spread = _spread == null ? null : _spread;
            return this;
        }

        @Override
        @RosettaAttribute(value="bondEquityModel", isRequired=true)
        @RuneAttribute(value="bondEquityModel", isRequired=true)
        public RelativePriceBuilder addBondEquityModel(BondEquityModel _bondEquityModel) {
            if (_bondEquityModel != null) {
                this.bondEquityModel.add(_bondEquityModel.toBuilder());
            }
            return this;
        }

        @Override
        public RelativePriceBuilder addBondEquityModel(BondEquityModel _bondEquityModel, int idx) {
            this.getIndex(this.bondEquityModel, idx, () -> _bondEquityModel.toBuilder());
            return this;
        }

        @Override
        public RelativePriceBuilder addBondEquityModel(List<? extends BondEquityModel> bondEquityModels) {
            if (bondEquityModels != null) {
                for (BondEquityModel bondEquityModel : bondEquityModels) {
                    this.bondEquityModel.add(bondEquityModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="bondEquityModel")
        public RelativePriceBuilder setBondEquityModel(List<? extends BondEquityModel> bondEquityModels) {
            this.bondEquityModel = bondEquityModels == null ? new ArrayList<BondEquityModel.BondEquityModelBuilder>() : (List)bondEquityModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RelativePrice build() {
            return new RelativePriceImpl(this);
        }

        @Override
        public RelativePriceBuilder toBuilder() {
            return this;
        }

        @Override
        public RelativePriceBuilder prune() {
            this.bondEquityModel = this.bondEquityModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSpread() != null) {
                return true;
            }
            return this.getBondEquityModel() != null && this.getBondEquityModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public RelativePriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RelativePriceBuilder o = (RelativePriceBuilder)other;
            merger.mergeRosetta(this.getBondEquityModel(), o.getBondEquityModel(), this::getOrCreateBondEquityModel);
            merger.mergeBasic((Object)this.getSpread(), (Object)o.getSpread(), this::setSpread, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RelativePrice _that = this.getType().cast(o);
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            return ListEquals.listEquals(this.bondEquityModel, _that.getBondEquityModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.bondEquityModel != null ? this.bondEquityModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RelativePriceBuilder {spread=" + this.spread + ", bondEquityModel=" + this.bondEquityModel + '}';
        }
    }

    public static interface RelativePriceBuilder
    extends RelativePrice,
    RosettaModelObjectBuilder {
        public BondEquityModel.BondEquityModelBuilder getOrCreateBondEquityModel(int var1);

        public List<? extends BondEquityModel.BondEquityModelBuilder> getBondEquityModel();

        public RelativePriceBuilder setSpread(BigDecimal var1);

        public RelativePriceBuilder addBondEquityModel(BondEquityModel var1);

        public RelativePriceBuilder addBondEquityModel(BondEquityModel var1, int var2);

        public RelativePriceBuilder addBondEquityModel(List<? extends BondEquityModel> var1);

        public RelativePriceBuilder setBondEquityModel(List<? extends BondEquityModel> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bondEquityModel"), processor, BondEquityModel.BondEquityModelBuilder.class, this.getBondEquityModel(), new AttributeMeta[0]);
        }

        public RelativePriceBuilder prune();
    }

    public static class RelativePriceImpl
    implements RelativePrice {
        private final BigDecimal spread;
        private final List<? extends BondEquityModel> bondEquityModel;

        protected RelativePriceImpl(RelativePriceBuilder builder) {
            this.spread = builder.getSpread();
            this.bondEquityModel = Optional.ofNullable(builder.getBondEquityModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="spread", isRequired=true)
        @RuneAttribute(value="spread", isRequired=true)
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="bondEquityModel", isRequired=true)
        @RuneAttribute(value="bondEquityModel", isRequired=true)
        public List<? extends BondEquityModel> getBondEquityModel() {
            return this.bondEquityModel;
        }

        @Override
        public RelativePrice build() {
            return this;
        }

        @Override
        public RelativePriceBuilder toBuilder() {
            RelativePriceBuilder builder = RelativePrice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RelativePriceBuilder builder) {
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getBondEquityModel()).ifPresent(builder::setBondEquityModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RelativePrice _that = this.getType().cast(o);
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            return ListEquals.listEquals(this.bondEquityModel, _that.getBondEquityModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.bondEquityModel != null ? this.bondEquityModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RelativePrice {spread=" + this.spread + ", bondEquityModel=" + this.bondEquityModel + '}';
        }
    }
}

